// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtWellBoreFilter.h                            //
// ************************************************************************* //

#ifndef AVT_WellBore_FILTER_H
#define AVT_WellBore_FILTER_H

#include <avtDataTreeIterator.h>

#include <WellBoreAttributes.h>

#include <string>
#include <vector>

class vtkCellArray;
class vtkFloatArray;
class vtkPoints;
class vtkPolyData;

#define MAX_DETAIL_LEVELS 4


// ****************************************************************************
//  Class: avtWellBoreFilter
//
//  Purpose:
//      This operator is the implied operator associated with an WellBore plot.
//
//  Programmer: brugger -- generated by xml2avt
//  Creation:   Wed Aug 27 14:59:19 PST 2008
//
//  Modifications:
//      Eric Brugger, Mon Nov 10 13:06:30 PST 2008
//      Added the ability to add a well bore name and stem.
//
//      Eric Brugger, Tue Aug 19 14:15:00 PDT 2014
//      Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtWellBoreFilter : public avtSIMODataTreeIterator
{
  public:
                              avtWellBoreFilter(WellBoreAttributes &wb_atts);
    virtual                  ~avtWellBoreFilter();

    virtual const char       *GetType(void)   { return "avtWellBoreFilter"; };

    virtual const char       *GetDescription(void)
                                  { return "Performing WellBore"; };

    void                      SetAttributes(const WellBoreAttributes &wb_atts);

  protected:
    WellBoreAttributes        atts;

    float                    *cyl_pts[MAX_DETAIL_LEVELS];

    virtual avtDataTree_p     ExecuteDataTree(avtDataRepresentation *);
    virtual void              RefashionDataObjectInfo(void);

    void                      CalculateCylPts(void);
    bool                      GetPoint(int [3], const std::vector<int> &,
                                  int &);
    vtkPolyData              *CreateWell(const std::vector<int> &, int &,
                                  const std::string &, float *, float *, float *,
                                  float *, int [3], int [3]);
    void                      AddWellSegment(vtkPoints *, vtkFloatArray *,
                                  vtkCellArray *, vtkCellArray *, int &,
                                  double [3], double [3]);
};


#endif
