// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VolumeViewerEnginePluginInfo.C
// ****************************************************************************

#include <VolumePluginInfo.h>
#include <avtVolumePlot.h>
#include <VolumeAttributes.h>

//
// Storage for static data elements.
//
VolumeAttributes *VolumeViewerEnginePluginInfo::clientAtts = NULL;
VolumeAttributes *VolumeViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  VolumeViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//    Kathleen Biagas, Fri Jun  8 12:07:11 PDT 2018
//    Mimic the auto-init functionality of vtkVolumeRenderingOpenGL2.
//    Can't use it here, because the factory won't be unregistered when this
//    library is unloaded.
//
// ****************************************************************************

#include <vtkRenderingVolumeOpenGL2ObjectFactory.h>

static vtkRenderingVolumeOpenGL2ObjectFactory *volFactory = NULL;
static int volFactory_count = 0;

void
VolumeViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (VolumeViewerEnginePluginInfo::clientAtts == NULL)
    {
        VolumeViewerEnginePluginInfo::clientAtts  = new VolumeAttributes;
        VolumeViewerEnginePluginInfo::defaultAtts = new VolumeAttributes;
    }
    // Want to ensure only 1 factory gets registered for this lib
    if (++volFactory_count == 1)
    {
        volFactory = vtkRenderingVolumeOpenGL2ObjectFactory::New();
        vtkObjectFactory::RegisterFactory(volFactory);
        volFactory->Delete();
    }
}


// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VolumeViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VolumeViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VolumeViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(VolumeAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VolumeViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(VolumeAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
VolumeViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtVolumePlot;
}

bool
VolumeViewerEnginePluginInfo::Permits2DViewScaling() const
{
    return false;
}

// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VolumeViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(VolumeAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: VolumeViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VolumeViewerEnginePluginInfo::GetMenuName() const
{
    return "Volume";
}

// ****************************************************************************
//  Method:  VolumeViewerEnginePluginInfo::Destructor
//
//  Purpose:
//    Unregister the volume factory.
//
//  Programmer: Kathleen Biagas
//  Creation:   June 8, 2018
//
//  Modifications:
//
// ****************************************************************************

VolumeViewerEnginePluginInfo::~VolumeViewerEnginePluginInfo()
{
    // Want to ensure only 1 factory gets unregistered for this lib
    if (--volFactory_count == 0)
    {
        vtkObjectFactory::UnRegisterFactory(volFactory);
    }
}

