// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VectorViewerEnginePluginInfo.C
// ****************************************************************************

#include <VectorPluginInfo.h>
#include <avtVectorPlot.h>
#include <VectorAttributes.h>

//
// Storage for static data elements.
//
VectorAttributes *VectorViewerEnginePluginInfo::clientAtts = NULL;
VectorAttributes *VectorViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  VectorViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
VectorViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (VectorViewerEnginePluginInfo::clientAtts == NULL)
    {
        VectorViewerEnginePluginInfo::clientAtts  = new VectorAttributes;
        VectorViewerEnginePluginInfo::defaultAtts = new VectorAttributes;
    }
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VectorViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VectorViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(VectorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(VectorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
VectorViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtVectorPlot;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(VectorAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
// Method: VectorViewerEnginePluginInfo::SupportsAnimation
//
// Purpose:
//   Tell VisIt that this plot supports animation.
//
// Programmer: Brad Whitlock
// Creation:   Fri Sep 13 11:29:59 PDT 2013
//
// Modifications:
//
// ****************************************************************************

bool
VectorViewerEnginePluginInfo::SupportsAnimation() const
{
    return true;
}

// ****************************************************************************
// Method: VectorViewerEnginePluginInfo::AnimationReset
//
// Purpose:
//   Resets the plot's animation.
//
// Arguments:
//   atts : The attribute subject that we may modify.
//   plot : The plot that we're animating.
//
// Returns:  True if the plot attributes changed as a result of reset.
//
// Programmer: Brad Whitlock
// Creation:   Fri Sep 13 11:29:59 PDT 2013
//
// Modifications:
//
// ****************************************************************************
#include <avtPlotMetaData.h>

bool
VectorViewerEnginePluginInfo::AnimationReset(AttributeSubject *atts, const avtPlotMetaData &)
{
    VectorAttributes *cAtts = (VectorAttributes *)atts;
    cAtts->SetAnimationStep(0);
    return true;
}

// ****************************************************************************
// Method: VectorViewerEnginePluginInfo::AnimationStep
//
// Purpose:
//   Take an animation step.
//
// Arguments:
//   atts : The attribute subject that we may modify.
//   plot : The plot that we're animating.
//
// Returns:  True if the plot attributes changed.
//
// Programmer: Brad Whitlock
// Creation:   Fri Sep 13 11:29:59 PDT 2013
//
// Modifications:
//
// ****************************************************************************

bool
VectorViewerEnginePluginInfo::AnimationStep(AttributeSubject *atts, const avtPlotMetaData &)
{
    VectorAttributes *cAtts = (VectorAttributes *)atts;
    cAtts->SetAnimationStep(cAtts->GetAnimationStep()+1);
    return true;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VectorViewerEnginePluginInfo::GetMenuName() const
{
    return "Vector";
}

