// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  VectorScriptingPluginInfo.C
// ************************************************************************* //
#include <PyVectorAttributes.h>
#include <VectorPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Vector,Scripting)

// ****************************************************************************
// Method: VectorScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
VectorScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyVectorAttributes_StartUp((VectorAttributes *)subj, data);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
VectorScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyVectorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Vector plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VectorScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyVectorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
VectorScriptingPluginInfo::GetLogString()
{
    std::string s(PyVectorAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: VectorScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
VectorScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyVectorAttributes_SetDefaults((const VectorAttributes *)atts);
}
