// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VectorPluginInfo.C
// ****************************************************************************

#include <VectorPluginInfo.h>
#include <VectorAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Vector,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Vector,General)

// ****************************************************************************
//  Method: VectorGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VectorGeneralPluginInfo::GetName() const
{
    return "Vector";
}

// ****************************************************************************
//  Method: VectorGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VectorGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: VectorGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VectorGeneralPluginInfo::GetID() const
{
    return "Vector_1.0";
}
// ****************************************************************************
//  Method: VectorGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VectorGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
