// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VectorGUIPluginInfo.C
// ****************************************************************************

#include <VectorPluginInfo.h>
#include <VectorAttributes.h>
#include <QApplication>
#include <QvisVectorPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Vector,GUI)

// ****************************************************************************
//  Method: VectorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
VectorGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Vector"));
}


// ****************************************************************************
//  Method: VectorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
VectorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisVectorPlotWindow(type, (VectorAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: VectorGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Vector.xpm>
const char **
VectorGUIPluginInfo::XPMIconData() const
{
    return Vector_xpm;
}

