// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: VectorAttributes
//
// Purpose:
//    Attributes for the vector plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class VectorAttributes extends AttributeSubject implements Plugin
{
    private static int VectorAttributes_numAdditionalAtts = 27;

    // Enum values
    public final static int QUALITY_FAST = 0;
    public final static int QUALITY_HIGH = 1;

    public final static int ORIGINTYPE_HEAD = 0;
    public final static int ORIGINTYPE_MIDDLE = 1;
    public final static int ORIGINTYPE_TAIL = 2;

    public final static int GLYPHTYPE_ARROW = 0;
    public final static int GLYPHTYPE_ELLIPSOID = 1;

    public final static int LINESTEM_CYLINDER = 0;
    public final static int LINESTEM_LINE = 1;

    public final static int LIMITSMODE_ORIGINALDATA = 0;
    public final static int LIMITSMODE_CURRENTPLOT = 1;

    public final static int GLYPHLOCATION_ADAPTSTOMESHRESOLUTION = 0;
    public final static int GLYPHLOCATION_UNIFORMINSPACE = 1;


    public VectorAttributes()
    {
        super(VectorAttributes_numAdditionalAtts);

        glyphLocation = GLYPHLOCATION_ADAPTSTOMESHRESOLUTION;
        useStride = false;
        nVectors = 400;
        stride = 1;
        origOnly = true;
        limitsMode = LIMITSMODE_ORIGINALDATA;
        minFlag = false;
        min = 0;
        maxFlag = false;
        max = 1;
        colorByMagnitude = true;
        colorTableName = new String("Default");
        invertColorTable = false;
        vectorColor = new ColorAttribute(0, 0, 0);
        useLegend = true;
        scale = 0.25;
        scaleByMagnitude = true;
        autoScale = true;
        glyphType = GLYPHTYPE_ARROW;
        headOn = true;
        headSize = 0.25;
        lineStem = LINESTEM_LINE;
        lineWidth = 0;
        stemWidth = 0.08;
        vectorOrigin = ORIGINTYPE_TAIL;
        geometryQuality = QUALITY_FAST;
        animationStep = 0;
    }

    public VectorAttributes(int nMoreFields)
    {
        super(VectorAttributes_numAdditionalAtts + nMoreFields);

        glyphLocation = GLYPHLOCATION_ADAPTSTOMESHRESOLUTION;
        useStride = false;
        nVectors = 400;
        stride = 1;
        origOnly = true;
        limitsMode = LIMITSMODE_ORIGINALDATA;
        minFlag = false;
        min = 0;
        maxFlag = false;
        max = 1;
        colorByMagnitude = true;
        colorTableName = new String("Default");
        invertColorTable = false;
        vectorColor = new ColorAttribute(0, 0, 0);
        useLegend = true;
        scale = 0.25;
        scaleByMagnitude = true;
        autoScale = true;
        glyphType = GLYPHTYPE_ARROW;
        headOn = true;
        headSize = 0.25;
        lineStem = LINESTEM_LINE;
        lineWidth = 0;
        stemWidth = 0.08;
        vectorOrigin = ORIGINTYPE_TAIL;
        geometryQuality = QUALITY_FAST;
        animationStep = 0;
    }

    public VectorAttributes(VectorAttributes obj)
    {
        super(obj);

        glyphLocation = obj.glyphLocation;
        useStride = obj.useStride;
        nVectors = obj.nVectors;
        stride = obj.stride;
        origOnly = obj.origOnly;
        limitsMode = obj.limitsMode;
        minFlag = obj.minFlag;
        min = obj.min;
        maxFlag = obj.maxFlag;
        max = obj.max;
        colorByMagnitude = obj.colorByMagnitude;
        colorTableName = new String(obj.colorTableName);
        invertColorTable = obj.invertColorTable;
        vectorColor = new ColorAttribute(obj.vectorColor);
        useLegend = obj.useLegend;
        scale = obj.scale;
        scaleByMagnitude = obj.scaleByMagnitude;
        autoScale = obj.autoScale;
        glyphType = obj.glyphType;
        headOn = obj.headOn;
        headSize = obj.headSize;
        lineStem = obj.lineStem;
        lineWidth = obj.lineWidth;
        stemWidth = obj.stemWidth;
        vectorOrigin = obj.vectorOrigin;
        geometryQuality = obj.geometryQuality;
        animationStep = obj.animationStep;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return VectorAttributes_numAdditionalAtts;
    }

    public boolean equals(VectorAttributes obj)
    {
        // Create the return value
        return ((glyphLocation == obj.glyphLocation) &&
                (useStride == obj.useStride) &&
                (nVectors == obj.nVectors) &&
                (stride == obj.stride) &&
                (origOnly == obj.origOnly) &&
                (limitsMode == obj.limitsMode) &&
                (minFlag == obj.minFlag) &&
                (min == obj.min) &&
                (maxFlag == obj.maxFlag) &&
                (max == obj.max) &&
                (colorByMagnitude == obj.colorByMagnitude) &&
                (colorTableName.equals(obj.colorTableName)) &&
                (invertColorTable == obj.invertColorTable) &&
                (vectorColor == obj.vectorColor) &&
                (useLegend == obj.useLegend) &&
                (scale == obj.scale) &&
                (scaleByMagnitude == obj.scaleByMagnitude) &&
                (autoScale == obj.autoScale) &&
                (glyphType == obj.glyphType) &&
                (headOn == obj.headOn) &&
                (headSize == obj.headSize) &&
                (lineStem == obj.lineStem) &&
                (lineWidth == obj.lineWidth) &&
                (stemWidth == obj.stemWidth) &&
                (vectorOrigin == obj.vectorOrigin) &&
                (geometryQuality == obj.geometryQuality) &&
                (animationStep == obj.animationStep));
    }

    public String GetName() { return "Vector"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetGlyphLocation(int glyphLocation_)
    {
        glyphLocation = glyphLocation_;
        Select(0);
    }

    public void SetUseStride(boolean useStride_)
    {
        useStride = useStride_;
        Select(1);
    }

    public void SetNVectors(int nVectors_)
    {
        nVectors = nVectors_;
        Select(2);
    }

    public void SetStride(int stride_)
    {
        stride = stride_;
        Select(3);
    }

    public void SetOrigOnly(boolean origOnly_)
    {
        origOnly = origOnly_;
        Select(4);
    }

    public void SetLimitsMode(int limitsMode_)
    {
        limitsMode = limitsMode_;
        Select(5);
    }

    public void SetMinFlag(boolean minFlag_)
    {
        minFlag = minFlag_;
        Select(6);
    }

    public void SetMin(double min_)
    {
        min = min_;
        Select(7);
    }

    public void SetMaxFlag(boolean maxFlag_)
    {
        maxFlag = maxFlag_;
        Select(8);
    }

    public void SetMax(double max_)
    {
        max = max_;
        Select(9);
    }

    public void SetColorByMagnitude(boolean colorByMagnitude_)
    {
        colorByMagnitude = colorByMagnitude_;
        Select(10);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(11);
    }

    public void SetInvertColorTable(boolean invertColorTable_)
    {
        invertColorTable = invertColorTable_;
        Select(12);
    }

    public void SetVectorColor(ColorAttribute vectorColor_)
    {
        vectorColor = vectorColor_;
        Select(13);
    }

    public void SetUseLegend(boolean useLegend_)
    {
        useLegend = useLegend_;
        Select(14);
    }

    public void SetScale(double scale_)
    {
        scale = scale_;
        Select(15);
    }

    public void SetScaleByMagnitude(boolean scaleByMagnitude_)
    {
        scaleByMagnitude = scaleByMagnitude_;
        Select(16);
    }

    public void SetAutoScale(boolean autoScale_)
    {
        autoScale = autoScale_;
        Select(17);
    }

    public void SetGlyphType(int glyphType_)
    {
        glyphType = glyphType_;
        Select(18);
    }

    public void SetHeadOn(boolean headOn_)
    {
        headOn = headOn_;
        Select(19);
    }

    public void SetHeadSize(double headSize_)
    {
        headSize = headSize_;
        Select(20);
    }

    public void SetLineStem(int lineStem_)
    {
        lineStem = lineStem_;
        Select(21);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(22);
    }

    public void SetStemWidth(double stemWidth_)
    {
        stemWidth = stemWidth_;
        Select(23);
    }

    public void SetVectorOrigin(int vectorOrigin_)
    {
        vectorOrigin = vectorOrigin_;
        Select(24);
    }

    public void SetGeometryQuality(int geometryQuality_)
    {
        geometryQuality = geometryQuality_;
        Select(25);
    }

    public void SetAnimationStep(int animationStep_)
    {
        animationStep = animationStep_;
        Select(26);
    }

    // Property getting methods
    public int            GetGlyphLocation() { return glyphLocation; }
    public boolean        GetUseStride() { return useStride; }
    public int            GetNVectors() { return nVectors; }
    public int            GetStride() { return stride; }
    public boolean        GetOrigOnly() { return origOnly; }
    public int            GetLimitsMode() { return limitsMode; }
    public boolean        GetMinFlag() { return minFlag; }
    public double         GetMin() { return min; }
    public boolean        GetMaxFlag() { return maxFlag; }
    public double         GetMax() { return max; }
    public boolean        GetColorByMagnitude() { return colorByMagnitude; }
    public String         GetColorTableName() { return colorTableName; }
    public boolean        GetInvertColorTable() { return invertColorTable; }
    public ColorAttribute GetVectorColor() { return vectorColor; }
    public boolean        GetUseLegend() { return useLegend; }
    public double         GetScale() { return scale; }
    public boolean        GetScaleByMagnitude() { return scaleByMagnitude; }
    public boolean        GetAutoScale() { return autoScale; }
    public int            GetGlyphType() { return glyphType; }
    public boolean        GetHeadOn() { return headOn; }
    public double         GetHeadSize() { return headSize; }
    public int            GetLineStem() { return lineStem; }
    public int            GetLineWidth() { return lineWidth; }
    public double         GetStemWidth() { return stemWidth; }
    public int            GetVectorOrigin() { return vectorOrigin; }
    public int            GetGeometryQuality() { return geometryQuality; }
    public int            GetAnimationStep() { return animationStep; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(glyphLocation);
        if(WriteSelect(1, buf))
            buf.WriteBool(useStride);
        if(WriteSelect(2, buf))
            buf.WriteInt(nVectors);
        if(WriteSelect(3, buf))
            buf.WriteInt(stride);
        if(WriteSelect(4, buf))
            buf.WriteBool(origOnly);
        if(WriteSelect(5, buf))
            buf.WriteInt(limitsMode);
        if(WriteSelect(6, buf))
            buf.WriteBool(minFlag);
        if(WriteSelect(7, buf))
            buf.WriteDouble(min);
        if(WriteSelect(8, buf))
            buf.WriteBool(maxFlag);
        if(WriteSelect(9, buf))
            buf.WriteDouble(max);
        if(WriteSelect(10, buf))
            buf.WriteBool(colorByMagnitude);
        if(WriteSelect(11, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(12, buf))
            buf.WriteBool(invertColorTable);
        if(WriteSelect(13, buf))
            vectorColor.Write(buf);
        if(WriteSelect(14, buf))
            buf.WriteBool(useLegend);
        if(WriteSelect(15, buf))
            buf.WriteDouble(scale);
        if(WriteSelect(16, buf))
            buf.WriteBool(scaleByMagnitude);
        if(WriteSelect(17, buf))
            buf.WriteBool(autoScale);
        if(WriteSelect(18, buf))
            buf.WriteInt(glyphType);
        if(WriteSelect(19, buf))
            buf.WriteBool(headOn);
        if(WriteSelect(20, buf))
            buf.WriteDouble(headSize);
        if(WriteSelect(21, buf))
            buf.WriteInt(lineStem);
        if(WriteSelect(22, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(23, buf))
            buf.WriteDouble(stemWidth);
        if(WriteSelect(24, buf))
            buf.WriteInt(vectorOrigin);
        if(WriteSelect(25, buf))
            buf.WriteInt(geometryQuality);
        if(WriteSelect(26, buf))
            buf.WriteInt(animationStep);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetGlyphLocation(buf.ReadInt());
            break;
        case 1:
            SetUseStride(buf.ReadBool());
            break;
        case 2:
            SetNVectors(buf.ReadInt());
            break;
        case 3:
            SetStride(buf.ReadInt());
            break;
        case 4:
            SetOrigOnly(buf.ReadBool());
            break;
        case 5:
            SetLimitsMode(buf.ReadInt());
            break;
        case 6:
            SetMinFlag(buf.ReadBool());
            break;
        case 7:
            SetMin(buf.ReadDouble());
            break;
        case 8:
            SetMaxFlag(buf.ReadBool());
            break;
        case 9:
            SetMax(buf.ReadDouble());
            break;
        case 10:
            SetColorByMagnitude(buf.ReadBool());
            break;
        case 11:
            SetColorTableName(buf.ReadString());
            break;
        case 12:
            SetInvertColorTable(buf.ReadBool());
            break;
        case 13:
            vectorColor.Read(buf);
            Select(13);
            break;
        case 14:
            SetUseLegend(buf.ReadBool());
            break;
        case 15:
            SetScale(buf.ReadDouble());
            break;
        case 16:
            SetScaleByMagnitude(buf.ReadBool());
            break;
        case 17:
            SetAutoScale(buf.ReadBool());
            break;
        case 18:
            SetGlyphType(buf.ReadInt());
            break;
        case 19:
            SetHeadOn(buf.ReadBool());
            break;
        case 20:
            SetHeadSize(buf.ReadDouble());
            break;
        case 21:
            SetLineStem(buf.ReadInt());
            break;
        case 22:
            SetLineWidth(buf.ReadInt());
            break;
        case 23:
            SetStemWidth(buf.ReadDouble());
            break;
        case 24:
            SetVectorOrigin(buf.ReadInt());
            break;
        case 25:
            SetGeometryQuality(buf.ReadInt());
            break;
        case 26:
            SetAnimationStep(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "glyphLocation = ";
        if(glyphLocation == GLYPHLOCATION_ADAPTSTOMESHRESOLUTION)
            str = str + "GLYPHLOCATION_ADAPTSTOMESHRESOLUTION";
        if(glyphLocation == GLYPHLOCATION_UNIFORMINSPACE)
            str = str + "GLYPHLOCATION_UNIFORMINSPACE";
        str = str + "\n";
        str = str + boolToString("useStride", useStride, indent) + "\n";
        str = str + intToString("nVectors", nVectors, indent) + "\n";
        str = str + intToString("stride", stride, indent) + "\n";
        str = str + boolToString("origOnly", origOnly, indent) + "\n";
        str = str + indent + "limitsMode = ";
        if(limitsMode == LIMITSMODE_ORIGINALDATA)
            str = str + "LIMITSMODE_ORIGINALDATA";
        if(limitsMode == LIMITSMODE_CURRENTPLOT)
            str = str + "LIMITSMODE_CURRENTPLOT";
        str = str + "\n";
        str = str + boolToString("minFlag", minFlag, indent) + "\n";
        str = str + doubleToString("min", min, indent) + "\n";
        str = str + boolToString("maxFlag", maxFlag, indent) + "\n";
        str = str + doubleToString("max", max, indent) + "\n";
        str = str + boolToString("colorByMagnitude", colorByMagnitude, indent) + "\n";
        str = str + stringToString("colorTableName", colorTableName, indent) + "\n";
        str = str + boolToString("invertColorTable", invertColorTable, indent) + "\n";
        str = str + indent + "vectorColor = {" + vectorColor.Red() + ", " + vectorColor.Green() + ", " + vectorColor.Blue() + ", " + vectorColor.Alpha() + "}\n";
        str = str + boolToString("useLegend", useLegend, indent) + "\n";
        str = str + doubleToString("scale", scale, indent) + "\n";
        str = str + boolToString("scaleByMagnitude", scaleByMagnitude, indent) + "\n";
        str = str + boolToString("autoScale", autoScale, indent) + "\n";
        str = str + indent + "glyphType = ";
        if(glyphType == GLYPHTYPE_ARROW)
            str = str + "GLYPHTYPE_ARROW";
        if(glyphType == GLYPHTYPE_ELLIPSOID)
            str = str + "GLYPHTYPE_ELLIPSOID";
        str = str + "\n";
        str = str + boolToString("headOn", headOn, indent) + "\n";
        str = str + doubleToString("headSize", headSize, indent) + "\n";
        str = str + indent + "lineStem = ";
        if(lineStem == LINESTEM_CYLINDER)
            str = str + "LINESTEM_CYLINDER";
        if(lineStem == LINESTEM_LINE)
            str = str + "LINESTEM_LINE";
        str = str + "\n";
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + doubleToString("stemWidth", stemWidth, indent) + "\n";
        str = str + indent + "vectorOrigin = ";
        if(vectorOrigin == ORIGINTYPE_HEAD)
            str = str + "ORIGINTYPE_HEAD";
        if(vectorOrigin == ORIGINTYPE_MIDDLE)
            str = str + "ORIGINTYPE_MIDDLE";
        if(vectorOrigin == ORIGINTYPE_TAIL)
            str = str + "ORIGINTYPE_TAIL";
        str = str + "\n";
        str = str + indent + "geometryQuality = ";
        if(geometryQuality == QUALITY_FAST)
            str = str + "QUALITY_FAST";
        if(geometryQuality == QUALITY_HIGH)
            str = str + "QUALITY_HIGH";
        str = str + "\n";
        str = str + intToString("animationStep", animationStep, indent) + "\n";
        return str;
    }


    // Attributes
    private int            glyphLocation;
    private boolean        useStride;
    private int            nVectors;
    private int            stride;
    private boolean        origOnly;
    private int            limitsMode;
    private boolean        minFlag;
    private double         min;
    private boolean        maxFlag;
    private double         max;
    private boolean        colorByMagnitude;
    private String         colorTableName;
    private boolean        invertColorTable;
    private ColorAttribute vectorColor;
    private boolean        useLegend;
    private double         scale;
    private boolean        scaleByMagnitude;
    private boolean        autoScale;
    private int            glyphType;
    private boolean        headOn;
    private double         headSize;
    private int            lineStem;
    private int            lineWidth;
    private double         stemWidth;
    private int            vectorOrigin;
    private int            geometryQuality;
    private int            animationStep;
}

