// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TruecolorViewerEnginePluginInfo.C
// ****************************************************************************

#include <TruecolorPluginInfo.h>
#include <avtTruecolorPlot.h>
#include <TruecolorAttributes.h>

//
// Storage for static data elements.
//
TruecolorAttributes *TruecolorViewerEnginePluginInfo::clientAtts = NULL;
TruecolorAttributes *TruecolorViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TruecolorViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
TruecolorViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (TruecolorViewerEnginePluginInfo::clientAtts == NULL)
    {
        TruecolorViewerEnginePluginInfo::clientAtts  = new TruecolorAttributes;
        TruecolorViewerEnginePluginInfo::defaultAtts = new TruecolorAttributes;
    }
}

// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TruecolorViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TruecolorViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TruecolorViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TruecolorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TruecolorViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TruecolorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
TruecolorViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtTruecolorPlot;
}

// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TruecolorViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(TruecolorAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: TruecolorViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TruecolorViewerEnginePluginInfo::GetMenuName() const
{
    return "Truecolor";
}

