// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TruecolorPluginInfo.C
// ****************************************************************************

#include <TruecolorPluginInfo.h>
#include <TruecolorAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Truecolor,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Truecolor,General)

// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TruecolorGeneralPluginInfo::GetName() const
{
    return "Truecolor";
}

// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TruecolorGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TruecolorGeneralPluginInfo::GetID() const
{
    return "Truecolor_1.0";
}
// ****************************************************************************
//  Method: TruecolorGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
TruecolorGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
