// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TruecolorGUIPluginInfo.C
// ****************************************************************************

#include <TruecolorPluginInfo.h>
#include <TruecolorAttributes.h>
#include <QApplication>
#include <QvisTruecolorPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Truecolor,GUI)

// ****************************************************************************
//  Method: TruecolorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
TruecolorGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Truecolor"));
}


// ****************************************************************************
//  Method: TruecolorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
TruecolorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisTruecolorPlotWindow(type, (TruecolorAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: TruecolorGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Truecolor.xpm>
const char **
TruecolorGUIPluginInfo::XPMIconData() const
{
    return Truecolor_xpm;
}

