// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TruecolorCommonPluginInfo.C
// ****************************************************************************

#include <TruecolorPluginInfo.h>
#include <TruecolorAttributes.h>

// ****************************************************************************
//  Method: TruecolorCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TruecolorCommonPluginInfo::AllocAttributes()
{
    return new TruecolorAttributes;
}

// ****************************************************************************
//  Method: TruecolorCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Truecolor attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TruecolorCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TruecolorAttributes *) to) = *((TruecolorAttributes *) from);
}

// ****************************************************************************
// Method: TruecolorCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
TruecolorCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}

