// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: TruecolorAttributes
//
// Purpose:
//    Truecolor plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class TruecolorAttributes extends AttributeSubject implements Plugin
{
    private static int TruecolorAttributes_numAdditionalAtts = 2;

    public TruecolorAttributes()
    {
        super(TruecolorAttributes_numAdditionalAtts);

        opacity = 1;
        lightingFlag = true;
    }

    public TruecolorAttributes(int nMoreFields)
    {
        super(TruecolorAttributes_numAdditionalAtts + nMoreFields);

        opacity = 1;
        lightingFlag = true;
    }

    public TruecolorAttributes(TruecolorAttributes obj)
    {
        super(obj);

        opacity = obj.opacity;
        lightingFlag = obj.lightingFlag;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return TruecolorAttributes_numAdditionalAtts;
    }

    public boolean equals(TruecolorAttributes obj)
    {
        // Create the return value
        return ((opacity == obj.opacity) &&
                (lightingFlag == obj.lightingFlag));
    }

    public String GetName() { return "Truecolor"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetOpacity(double opacity_)
    {
        opacity = opacity_;
        Select(0);
    }

    public void SetLightingFlag(boolean lightingFlag_)
    {
        lightingFlag = lightingFlag_;
        Select(1);
    }

    // Property getting methods
    public double  GetOpacity() { return opacity; }
    public boolean GetLightingFlag() { return lightingFlag; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteDouble(opacity);
        if(WriteSelect(1, buf))
            buf.WriteBool(lightingFlag);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetOpacity(buf.ReadDouble());
            break;
        case 1:
            SetLightingFlag(buf.ReadBool());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + doubleToString("opacity", opacity, indent) + "\n";
        str = str + boolToString("lightingFlag", lightingFlag, indent) + "\n";
        return str;
    }


    // Attributes
    private double  opacity;
    private boolean lightingFlag;
}

