// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtTopologyPlot.h                             //
// ************************************************************************* //

#ifndef AVT_Topology_PLOT_H
#define AVT_Topology_PLOT_H


#include <avtPlot.h>
#include <TopologyAttributes.h>

class     avtLevelsLegend;
class     avtLevelsMapper;
class     avtLookupTable;
class     avtTopologyFilter;
class     vtkProperty;

// ****************************************************************************
//  Class:  avtTopologyPlot
//
//  Purpose:
//      A concrete type of avtPlot, this is the Topology plot.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Fri Jun 27 09:00:35 PDT 2003
//
// ****************************************************************************

class avtTopologyPlot : public avtSurfaceDataPlot
{
  public:
                                avtTopologyPlot();
    virtual                    ~avtTopologyPlot();

    virtual const char         *GetName(void) { return "TopologyPlot"; };

    static avtPlot             *Create();

    virtual void                SetAtts(const AttributeGroup*);

    void                        SetLegend(bool);
    void                        SetLineWidth(int);
    
  protected:
    TopologyAttributes              atts;

    avtLevelsMapper                *levelsMapper;
    avtTopologyFilter              *topologyFilter;
    avtLevelsLegend                *levelsLegend;
    avtLegend_p                     levLegendRefPtr;
    avtLookupTable                 *avtLUT;

    double                          opacity[4];

    virtual avtMapperBase      *GetMapper(void);
    virtual avtDataObject_p     ApplyOperators(avtDataObject_p);
    virtual avtDataObject_p     ApplyRenderingTransformation(avtDataObject_p);
    virtual void                CustomizeBehavior(void);

    virtual avtLegend_p         GetLegend(void) { return levLegendRefPtr; };

    void                        SetColors();

    virtual void                ReleaseData();
};


#endif
