// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                              avtTopologyFilter.h                          //
// ************************************************************************* //

#ifndef AVT_Topology_FILTER_H
#define AVT_Topology_FILTER_H

#include <avtSIMODataTreeIterator.h>

#include <string>

class vtkCell;
class vtkContourFilter;
class vtkDataArray;
class vtkIdList;


// ****************************************************************************
//  Class: avtTopologyFilter
//
//  Purpose:
//      This operator is the implied operator associated with an Topology plot.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Thu Jun 26 15:59:09 PST 2003
//
//  Modifications:
//    Eric Brugger, Tue Aug 19 11:41:13 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtTopologyFilter : public avtSIMODataTreeIterator
{
  public:
    static const std::string labelNames[4];
      
                              avtTopologyFilter();
    virtual                  ~avtTopologyFilter();

    virtual const char       *GetType(void)   { return "avtTopologyFilter"; };
    virtual const char       *GetDescription(void)
                                  { return "Finding Topology"; };

    void              SetTolerance(double t)   { tolerance  =  t; }
    void              SetHitpercent(double hp) { hitpercent = hp; }

    virtual void              ReleaseData();

  protected:
    double tolerance;
    double hitpercent;
    
    vtkContourFilter *cf;
    
    virtual avtDataTree_p     ExecuteDataTree(avtDataRepresentation *);
    virtual void              UpdateDataObjectInfo(void);
    
    vtkDataArray             *GetGradient(vtkDataSet *, vtkDataArray *);

    float                     EvaluateComponent(float, float, float, float,
                                                float, float, float, 
                                                vtkDataSet *, vtkDataArray *,
                                                vtkIdList *);    
    
    float                     EvaluateValue(float, float, float, vtkDataSet *,
                                            vtkDataArray *,vtkIdList *,bool &);

    bool                      GetLocalGradient(int, vtkDataSet *,
                                               vtkDataArray *, double[3], int);
};


#endif
