// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TopologyCommonPluginInfo.C
// ****************************************************************************

#include <TopologyPluginInfo.h>
#include <TopologyAttributes.h>

// ****************************************************************************
//  Method: TopologyCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TopologyCommonPluginInfo::AllocAttributes()
{
    return new TopologyAttributes;
}

// ****************************************************************************
//  Method: TopologyCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Topology attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TopologyCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TopologyAttributes *) to) = *((TopologyAttributes *) from);
}

// ****************************************************************************
// Method: TopologyCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
TopologyCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

