// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttributeList;

// ****************************************************************************
// Class: TopologyAttributes
//
// Purpose:
//    This class contains the plot attributes for the topology plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class TopologyAttributes extends AttributeSubject implements Plugin
{
    private static int TopologyAttributes_numAdditionalAtts = 8;

    public TopologyAttributes()
    {
        super(TopologyAttributes_numAdditionalAtts);

        lineWidth = 2;
        multiColor = new ColorAttributeList();
        minOpacity = 1;
        minPlateauOpacity = 1;
        maxPlateauOpacity = 1;
        maxOpacity = 1;
        tolerance = 1e-06;
        hitpercent = 0;
    }

    public TopologyAttributes(int nMoreFields)
    {
        super(TopologyAttributes_numAdditionalAtts + nMoreFields);

        lineWidth = 2;
        multiColor = new ColorAttributeList();
        minOpacity = 1;
        minPlateauOpacity = 1;
        maxPlateauOpacity = 1;
        maxOpacity = 1;
        tolerance = 1e-06;
        hitpercent = 0;
    }

    public TopologyAttributes(TopologyAttributes obj)
    {
        super(obj);

        lineWidth = obj.lineWidth;
        multiColor = new ColorAttributeList(obj.multiColor);
        minOpacity = obj.minOpacity;
        minPlateauOpacity = obj.minPlateauOpacity;
        maxPlateauOpacity = obj.maxPlateauOpacity;
        maxOpacity = obj.maxOpacity;
        tolerance = obj.tolerance;
        hitpercent = obj.hitpercent;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return TopologyAttributes_numAdditionalAtts;
    }

    public boolean equals(TopologyAttributes obj)
    {
        // Create the return value
        return ((lineWidth == obj.lineWidth) &&
                (multiColor.equals(obj.multiColor)) &&
                (minOpacity == obj.minOpacity) &&
                (minPlateauOpacity == obj.minPlateauOpacity) &&
                (maxPlateauOpacity == obj.maxPlateauOpacity) &&
                (maxOpacity == obj.maxOpacity) &&
                (tolerance == obj.tolerance) &&
                (hitpercent == obj.hitpercent));
    }

    public String GetName() { return "Topology"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(0);
    }

    public void SetMultiColor(ColorAttributeList multiColor_)
    {
        multiColor = multiColor_;
        Select(1);
    }

    public void SetMinOpacity(double minOpacity_)
    {
        minOpacity = minOpacity_;
        Select(2);
    }

    public void SetMinPlateauOpacity(double minPlateauOpacity_)
    {
        minPlateauOpacity = minPlateauOpacity_;
        Select(3);
    }

    public void SetMaxPlateauOpacity(double maxPlateauOpacity_)
    {
        maxPlateauOpacity = maxPlateauOpacity_;
        Select(4);
    }

    public void SetMaxOpacity(double maxOpacity_)
    {
        maxOpacity = maxOpacity_;
        Select(5);
    }

    public void SetTolerance(double tolerance_)
    {
        tolerance = tolerance_;
        Select(6);
    }

    public void SetHitpercent(double hitpercent_)
    {
        hitpercent = hitpercent_;
        Select(7);
    }

    // Property getting methods
    public int                GetLineWidth() { return lineWidth; }
    public ColorAttributeList GetMultiColor() { return multiColor; }
    public double             GetMinOpacity() { return minOpacity; }
    public double             GetMinPlateauOpacity() { return minPlateauOpacity; }
    public double             GetMaxPlateauOpacity() { return maxPlateauOpacity; }
    public double             GetMaxOpacity() { return maxOpacity; }
    public double             GetTolerance() { return tolerance; }
    public double             GetHitpercent() { return hitpercent; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(1, buf))
            multiColor.Write(buf);
        if(WriteSelect(2, buf))
            buf.WriteDouble(minOpacity);
        if(WriteSelect(3, buf))
            buf.WriteDouble(minPlateauOpacity);
        if(WriteSelect(4, buf))
            buf.WriteDouble(maxPlateauOpacity);
        if(WriteSelect(5, buf))
            buf.WriteDouble(maxOpacity);
        if(WriteSelect(6, buf))
            buf.WriteDouble(tolerance);
        if(WriteSelect(7, buf))
            buf.WriteDouble(hitpercent);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetLineWidth(buf.ReadInt());
            break;
        case 1:
            multiColor.Read(buf);
            Select(1);
            break;
        case 2:
            SetMinOpacity(buf.ReadDouble());
            break;
        case 3:
            SetMinPlateauOpacity(buf.ReadDouble());
            break;
        case 4:
            SetMaxPlateauOpacity(buf.ReadDouble());
            break;
        case 5:
            SetMaxOpacity(buf.ReadDouble());
            break;
        case 6:
            SetTolerance(buf.ReadDouble());
            break;
        case 7:
            SetHitpercent(buf.ReadDouble());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("lineWidth", lineWidth, indent) + "\n";
        str = str + indent + "multiColor = {\n" + multiColor.toString(indent + "    ") + indent + "}\n";
        str = str + doubleToString("minOpacity", minOpacity, indent) + "\n";
        str = str + doubleToString("minPlateauOpacity", minPlateauOpacity, indent) + "\n";
        str = str + doubleToString("maxPlateauOpacity", maxPlateauOpacity, indent) + "\n";
        str = str + doubleToString("maxOpacity", maxOpacity, indent) + "\n";
        str = str + doubleToString("tolerance", tolerance, indent) + "\n";
        str = str + doubleToString("hitpercent", hitpercent, indent) + "\n";
        return str;
    }


    // Attributes
    private int                lineWidth;
    private ColorAttributeList multiColor;
    private double             minOpacity;
    private double             minPlateauOpacity;
    private double             maxPlateauOpacity;
    private double             maxOpacity;
    private double             tolerance;
    private double             hitpercent;
}

