// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                                 avtTensorPlot.h                           //
// ************************************************************************* //

#ifndef AVT_Tensor_PLOT_H
#define AVT_Tensor_PLOT_H

#include <avtLegend.h>
#include <avtPlot.h>

#include <TensorAttributes.h>

class     avtTensorFilter;
class     avtTensorGlyphMapper;
class     avtGhostZoneFilter;
class     avtResampleFilter;
class     avtVariableLegend;
class     avtLookupTable;

// ****************************************************************************
//  Class:  avtTensorPlot
//
//  Purpose:
//      A concrete type of avtPlot, this is the Tensor plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Sep 23 20:57:03 PST 2003
//
//  Modifications:
//
//    Mark C. Miller, Wed Aug 11 23:42:18 PDT 2004
//    Added GetCellCountMultiplierForSRThreshold
//
//    Mark C. Miller, Mon Aug 23 20:24:31 PDT 2004
//    Changed GetCellCountMultiplierForSRThreshold to Set...
//
//    Hank Childs, Wed Aug 13 13:45:33 PDT 2008
//    Turn on NeedZBufferToCompositeEvenIn2D, as tensor glyphs can bleed
//    into other processor's portion of image space.
//
//    Kathleen Biagas, Wed Feb 29 13:10:11 MST 2012
//    Add GetExtraInfoForPick.
//
// ****************************************************************************

class avtTensorPlot : public avtPointDataPlot
{
  public:
                                avtTensorPlot();
    virtual                    ~avtTensorPlot();

    virtual const char         *GetName(void) { return "TensorPlot"; };
    virtual void                ReleaseData(void);

    static avtPlot             *Create();

    virtual void                SetAtts(const AttributeGroup*);
    virtual bool                NeedZBufferToCompositeEvenIn2D(void)
                                                          { return true; };

    virtual const MapNode      &GetExtraInfoForPick(void);

  protected:
    TensorAttributes            atts;
    bool                        colorsInitialized;

    avtTensorGlyphMapper       *tensorMapper;
    avtVariableLegend          *varLegend;
    avtLegend_p                 varLegendRefPtr;
    avtTensorFilter            *TensorFilter;
    avtGhostZoneFilter         *ghostFilter;
    avtResampleFilter          *resampleFilter;
    avtLookupTable             *avtLUT;

    virtual avtMapperBase      *GetMapper(void);
    virtual avtDataObject_p     ApplyOperators(avtDataObject_p);
    virtual avtDataObject_p     ApplyRenderingTransformation(avtDataObject_p);
    virtual void                CustomizeBehavior(void);
    virtual void                CustomizeMapper(avtDataObjectInformation &);

    bool                        SetColorTable(const char *);
    void                        SetLimitsMode(int);
    void                        SetMapperColors(void);

    virtual avtLegend_p         GetLegend(void) { return varLegendRefPtr; };
    void                        SetLegend(bool);
    void                        SetLegendRanges();

    virtual void                SetCellCountMultiplierForSRThreshold(const avtDataObject_p);
};

#endif
