// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TensorCommonPluginInfo.C
// ****************************************************************************

#include <TensorPluginInfo.h>
#include <TensorAttributes.h>

// ****************************************************************************
//  Method: TensorCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TensorCommonPluginInfo::AllocAttributes()
{
    return new TensorAttributes;
}

// ****************************************************************************
//  Method: TensorCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Tensor attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TensorCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((TensorAttributes *) to) = *((TensorAttributes *) from);
}

// ****************************************************************************
// Method: TensorCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
TensorCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_TENSOR | VAR_CATEGORY_SYMMETRIC_TENSOR;
}

