// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: TensorAttributes
//
// Purpose:
//    Attributes for the tensor plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class TensorAttributes extends AttributeSubject implements Plugin
{
    private static int TensorAttributes_numAdditionalAtts = 19;

    // Enum values
    public final static int LIMITSMODE_ORIGINALDATA = 0;
    public final static int LIMITSMODE_CURRENTPLOT = 1;

    public final static int GLYPHLOCATION_ADAPTSTOMESHRESOLUTION = 0;
    public final static int GLYPHLOCATION_UNIFORMINSPACE = 1;


    public TensorAttributes()
    {
        super(TensorAttributes_numAdditionalAtts);

        glyphLocation = GLYPHLOCATION_ADAPTSTOMESHRESOLUTION;
        useStride = false;
        nTensors = 400;
        stride = 1;
        origOnly = true;
        limitsMode = LIMITSMODE_ORIGINALDATA;
        minFlag = false;
        min = 0;
        maxFlag = false;
        max = 1;
        colorByEigenValues = true;
        colorTableName = new String("Default");
        invertColorTable = false;
        tensorColor = new ColorAttribute(0, 0, 0);
        useLegend = true;
        scale = 0.25;
        scaleByMagnitude = true;
        autoScale = true;
        animationStep = 0;
    }

    public TensorAttributes(int nMoreFields)
    {
        super(TensorAttributes_numAdditionalAtts + nMoreFields);

        glyphLocation = GLYPHLOCATION_ADAPTSTOMESHRESOLUTION;
        useStride = false;
        nTensors = 400;
        stride = 1;
        origOnly = true;
        limitsMode = LIMITSMODE_ORIGINALDATA;
        minFlag = false;
        min = 0;
        maxFlag = false;
        max = 1;
        colorByEigenValues = true;
        colorTableName = new String("Default");
        invertColorTable = false;
        tensorColor = new ColorAttribute(0, 0, 0);
        useLegend = true;
        scale = 0.25;
        scaleByMagnitude = true;
        autoScale = true;
        animationStep = 0;
    }

    public TensorAttributes(TensorAttributes obj)
    {
        super(obj);

        glyphLocation = obj.glyphLocation;
        useStride = obj.useStride;
        nTensors = obj.nTensors;
        stride = obj.stride;
        origOnly = obj.origOnly;
        limitsMode = obj.limitsMode;
        minFlag = obj.minFlag;
        min = obj.min;
        maxFlag = obj.maxFlag;
        max = obj.max;
        colorByEigenValues = obj.colorByEigenValues;
        colorTableName = new String(obj.colorTableName);
        invertColorTable = obj.invertColorTable;
        tensorColor = new ColorAttribute(obj.tensorColor);
        useLegend = obj.useLegend;
        scale = obj.scale;
        scaleByMagnitude = obj.scaleByMagnitude;
        autoScale = obj.autoScale;
        animationStep = obj.animationStep;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return TensorAttributes_numAdditionalAtts;
    }

    public boolean equals(TensorAttributes obj)
    {
        // Create the return value
        return ((glyphLocation == obj.glyphLocation) &&
                (useStride == obj.useStride) &&
                (nTensors == obj.nTensors) &&
                (stride == obj.stride) &&
                (origOnly == obj.origOnly) &&
                (limitsMode == obj.limitsMode) &&
                (minFlag == obj.minFlag) &&
                (min == obj.min) &&
                (maxFlag == obj.maxFlag) &&
                (max == obj.max) &&
                (colorByEigenValues == obj.colorByEigenValues) &&
                (colorTableName.equals(obj.colorTableName)) &&
                (invertColorTable == obj.invertColorTable) &&
                (tensorColor == obj.tensorColor) &&
                (useLegend == obj.useLegend) &&
                (scale == obj.scale) &&
                (scaleByMagnitude == obj.scaleByMagnitude) &&
                (autoScale == obj.autoScale) &&
                (animationStep == obj.animationStep));
    }

    public String GetName() { return "Tensor"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetGlyphLocation(int glyphLocation_)
    {
        glyphLocation = glyphLocation_;
        Select(0);
    }

    public void SetUseStride(boolean useStride_)
    {
        useStride = useStride_;
        Select(1);
    }

    public void SetNTensors(int nTensors_)
    {
        nTensors = nTensors_;
        Select(2);
    }

    public void SetStride(int stride_)
    {
        stride = stride_;
        Select(3);
    }

    public void SetOrigOnly(boolean origOnly_)
    {
        origOnly = origOnly_;
        Select(4);
    }

    public void SetLimitsMode(int limitsMode_)
    {
        limitsMode = limitsMode_;
        Select(5);
    }

    public void SetMinFlag(boolean minFlag_)
    {
        minFlag = minFlag_;
        Select(6);
    }

    public void SetMin(double min_)
    {
        min = min_;
        Select(7);
    }

    public void SetMaxFlag(boolean maxFlag_)
    {
        maxFlag = maxFlag_;
        Select(8);
    }

    public void SetMax(double max_)
    {
        max = max_;
        Select(9);
    }

    public void SetColorByEigenValues(boolean colorByEigenValues_)
    {
        colorByEigenValues = colorByEigenValues_;
        Select(10);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(11);
    }

    public void SetInvertColorTable(boolean invertColorTable_)
    {
        invertColorTable = invertColorTable_;
        Select(12);
    }

    public void SetTensorColor(ColorAttribute tensorColor_)
    {
        tensorColor = tensorColor_;
        Select(13);
    }

    public void SetUseLegend(boolean useLegend_)
    {
        useLegend = useLegend_;
        Select(14);
    }

    public void SetScale(double scale_)
    {
        scale = scale_;
        Select(15);
    }

    public void SetScaleByMagnitude(boolean scaleByMagnitude_)
    {
        scaleByMagnitude = scaleByMagnitude_;
        Select(16);
    }

    public void SetAutoScale(boolean autoScale_)
    {
        autoScale = autoScale_;
        Select(17);
    }

    public void SetAnimationStep(int animationStep_)
    {
        animationStep = animationStep_;
        Select(18);
    }

    // Property getting methods
    public int            GetGlyphLocation() { return glyphLocation; }
    public boolean        GetUseStride() { return useStride; }
    public int            GetNTensors() { return nTensors; }
    public int            GetStride() { return stride; }
    public boolean        GetOrigOnly() { return origOnly; }
    public int            GetLimitsMode() { return limitsMode; }
    public boolean        GetMinFlag() { return minFlag; }
    public double         GetMin() { return min; }
    public boolean        GetMaxFlag() { return maxFlag; }
    public double         GetMax() { return max; }
    public boolean        GetColorByEigenValues() { return colorByEigenValues; }
    public String         GetColorTableName() { return colorTableName; }
    public boolean        GetInvertColorTable() { return invertColorTable; }
    public ColorAttribute GetTensorColor() { return tensorColor; }
    public boolean        GetUseLegend() { return useLegend; }
    public double         GetScale() { return scale; }
    public boolean        GetScaleByMagnitude() { return scaleByMagnitude; }
    public boolean        GetAutoScale() { return autoScale; }
    public int            GetAnimationStep() { return animationStep; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(glyphLocation);
        if(WriteSelect(1, buf))
            buf.WriteBool(useStride);
        if(WriteSelect(2, buf))
            buf.WriteInt(nTensors);
        if(WriteSelect(3, buf))
            buf.WriteInt(stride);
        if(WriteSelect(4, buf))
            buf.WriteBool(origOnly);
        if(WriteSelect(5, buf))
            buf.WriteInt(limitsMode);
        if(WriteSelect(6, buf))
            buf.WriteBool(minFlag);
        if(WriteSelect(7, buf))
            buf.WriteDouble(min);
        if(WriteSelect(8, buf))
            buf.WriteBool(maxFlag);
        if(WriteSelect(9, buf))
            buf.WriteDouble(max);
        if(WriteSelect(10, buf))
            buf.WriteBool(colorByEigenValues);
        if(WriteSelect(11, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(12, buf))
            buf.WriteBool(invertColorTable);
        if(WriteSelect(13, buf))
            tensorColor.Write(buf);
        if(WriteSelect(14, buf))
            buf.WriteBool(useLegend);
        if(WriteSelect(15, buf))
            buf.WriteDouble(scale);
        if(WriteSelect(16, buf))
            buf.WriteBool(scaleByMagnitude);
        if(WriteSelect(17, buf))
            buf.WriteBool(autoScale);
        if(WriteSelect(18, buf))
            buf.WriteInt(animationStep);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetGlyphLocation(buf.ReadInt());
            break;
        case 1:
            SetUseStride(buf.ReadBool());
            break;
        case 2:
            SetNTensors(buf.ReadInt());
            break;
        case 3:
            SetStride(buf.ReadInt());
            break;
        case 4:
            SetOrigOnly(buf.ReadBool());
            break;
        case 5:
            SetLimitsMode(buf.ReadInt());
            break;
        case 6:
            SetMinFlag(buf.ReadBool());
            break;
        case 7:
            SetMin(buf.ReadDouble());
            break;
        case 8:
            SetMaxFlag(buf.ReadBool());
            break;
        case 9:
            SetMax(buf.ReadDouble());
            break;
        case 10:
            SetColorByEigenValues(buf.ReadBool());
            break;
        case 11:
            SetColorTableName(buf.ReadString());
            break;
        case 12:
            SetInvertColorTable(buf.ReadBool());
            break;
        case 13:
            tensorColor.Read(buf);
            Select(13);
            break;
        case 14:
            SetUseLegend(buf.ReadBool());
            break;
        case 15:
            SetScale(buf.ReadDouble());
            break;
        case 16:
            SetScaleByMagnitude(buf.ReadBool());
            break;
        case 17:
            SetAutoScale(buf.ReadBool());
            break;
        case 18:
            SetAnimationStep(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "glyphLocation = ";
        if(glyphLocation == GLYPHLOCATION_ADAPTSTOMESHRESOLUTION)
            str = str + "GLYPHLOCATION_ADAPTSTOMESHRESOLUTION";
        if(glyphLocation == GLYPHLOCATION_UNIFORMINSPACE)
            str = str + "GLYPHLOCATION_UNIFORMINSPACE";
        str = str + "\n";
        str = str + boolToString("useStride", useStride, indent) + "\n";
        str = str + intToString("nTensors", nTensors, indent) + "\n";
        str = str + intToString("stride", stride, indent) + "\n";
        str = str + boolToString("origOnly", origOnly, indent) + "\n";
        str = str + indent + "limitsMode = ";
        if(limitsMode == LIMITSMODE_ORIGINALDATA)
            str = str + "LIMITSMODE_ORIGINALDATA";
        if(limitsMode == LIMITSMODE_CURRENTPLOT)
            str = str + "LIMITSMODE_CURRENTPLOT";
        str = str + "\n";
        str = str + boolToString("minFlag", minFlag, indent) + "\n";
        str = str + doubleToString("min", min, indent) + "\n";
        str = str + boolToString("maxFlag", maxFlag, indent) + "\n";
        str = str + doubleToString("max", max, indent) + "\n";
        str = str + boolToString("colorByEigenValues", colorByEigenValues, indent) + "\n";
        str = str + stringToString("colorTableName", colorTableName, indent) + "\n";
        str = str + boolToString("invertColorTable", invertColorTable, indent) + "\n";
        str = str + indent + "tensorColor = {" + tensorColor.Red() + ", " + tensorColor.Green() + ", " + tensorColor.Blue() + ", " + tensorColor.Alpha() + "}\n";
        str = str + boolToString("useLegend", useLegend, indent) + "\n";
        str = str + doubleToString("scale", scale, indent) + "\n";
        str = str + boolToString("scaleByMagnitude", scaleByMagnitude, indent) + "\n";
        str = str + boolToString("autoScale", autoScale, indent) + "\n";
        str = str + intToString("animationStep", animationStep, indent) + "\n";
        return str;
    }


    // Attributes
    private int            glyphLocation;
    private boolean        useStride;
    private int            nTensors;
    private int            stride;
    private boolean        origOnly;
    private int            limitsMode;
    private boolean        minFlag;
    private double         min;
    private boolean        maxFlag;
    private double         max;
    private boolean        colorByEigenValues;
    private String         colorTableName;
    private boolean        invertColorTable;
    private ColorAttribute tensorColor;
    private boolean        useLegend;
    private double         scale;
    private boolean        scaleByMagnitude;
    private boolean        autoScale;
    private int            animationStep;
}

