// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef TENSORATTRIBUTES_H
#define TENSORATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

#include <ColorAttribute.h>

// ****************************************************************************
// Class: TensorAttributes
//
// Purpose:
//    Attributes for the tensor plot
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class TensorAttributes : public AttributeSubject
{
public:
    enum LimitsMode
    {
        OriginalData,
        CurrentPlot
    };
    enum GlyphLocation
    {
        AdaptsToMeshResolution,
        UniformInSpace
    };

    // These constructors are for objects of this class
    TensorAttributes();
    TensorAttributes(const TensorAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    TensorAttributes(private_tmfs_t tmfs);
    TensorAttributes(const TensorAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~TensorAttributes();

    virtual TensorAttributes& operator = (const TensorAttributes &obj);
    virtual bool operator == (const TensorAttributes &obj) const;
    virtual bool operator != (const TensorAttributes &obj) const;
private:
    void Init();
    void Copy(const TensorAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectColorTableName();
    void SelectTensorColor();

    // Property setting methods
    void SetGlyphLocation(GlyphLocation glyphLocation_);
    void SetUseStride(bool useStride_);
    void SetNTensors(int nTensors_);
    void SetStride(int stride_);
    void SetOrigOnly(bool origOnly_);
    void SetLimitsMode(LimitsMode limitsMode_);
    void SetMinFlag(bool minFlag_);
    void SetMin(double min_);
    void SetMaxFlag(bool maxFlag_);
    void SetMax(double max_);
    void SetColorByEigenValues(bool colorByEigenValues_);
    void SetColorTableName(const std::string &colorTableName_);
    void SetInvertColorTable(bool invertColorTable_);
    void SetTensorColor(const ColorAttribute &tensorColor_);
    void SetUseLegend(bool useLegend_);
    void SetScale(double scale_);
    void SetScaleByMagnitude(bool scaleByMagnitude_);
    void SetAutoScale(bool autoScale_);
    void SetAnimationStep(int animationStep_);

    // Property getting methods
    GlyphLocation        GetGlyphLocation() const;
    bool                 GetUseStride() const;
    int                  GetNTensors() const;
    int                  GetStride() const;
    bool                 GetOrigOnly() const;
    LimitsMode           GetLimitsMode() const;
    bool                 GetMinFlag() const;
    double               GetMin() const;
    bool                 GetMaxFlag() const;
    double               GetMax() const;
    bool                 GetColorByEigenValues() const;
    const std::string    &GetColorTableName() const;
          std::string    &GetColorTableName();
    bool                 GetInvertColorTable() const;
    const ColorAttribute &GetTensorColor() const;
          ColorAttribute &GetTensorColor();
    bool                 GetUseLegend() const;
    double               GetScale() const;
    bool                 GetScaleByMagnitude() const;
    bool                 GetAutoScale() const;
    int                  GetAnimationStep() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string LimitsMode_ToString(LimitsMode);
    static bool LimitsMode_FromString(const std::string &, LimitsMode &);
protected:
    static std::string LimitsMode_ToString(int);
public:
    static std::string GlyphLocation_ToString(GlyphLocation);
    static bool GlyphLocation_FromString(const std::string &, GlyphLocation &);
protected:
    static std::string GlyphLocation_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool ChangesRequireRecalculation(const TensorAttributes &obj);
    double GetAnimationScale() const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_glyphLocation = 0,
        ID_useStride,
        ID_nTensors,
        ID_stride,
        ID_origOnly,
        ID_limitsMode,
        ID_minFlag,
        ID_min,
        ID_maxFlag,
        ID_max,
        ID_colorByEigenValues,
        ID_colorTableName,
        ID_invertColorTable,
        ID_tensorColor,
        ID_useLegend,
        ID_scale,
        ID_scaleByMagnitude,
        ID_autoScale,
        ID_animationStep,
        ID__LAST
    };

private:
    int            glyphLocation;
    bool           useStride;
    int            nTensors;
    int            stride;
    bool           origOnly;
    int            limitsMode;
    bool           minFlag;
    double         min;
    bool           maxFlag;
    double         max;
    bool           colorByEigenValues;
    std::string    colorTableName;
    bool           invertColorTable;
    ColorAttribute tensorColor;
    bool           useLegend;
    double         scale;
    bool           scaleByMagnitude;
    bool           autoScale;
    int            animationStep;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define TENSORATTRIBUTES_TMFS "ibiibibdbdbsbabdbbi"

#endif
