// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfaceViewerEnginePluginInfo.C
// ****************************************************************************

#include <SurfacePluginInfo.h>
#include <avtSurfacePlot.h>
#include <SurfaceAttributes.h>

//
// Storage for static data elements.
//
SurfaceAttributes *SurfaceViewerEnginePluginInfo::clientAtts = NULL;
SurfaceAttributes *SurfaceViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SurfaceViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
SurfaceViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (SurfaceViewerEnginePluginInfo::clientAtts == NULL)
    {
        SurfaceViewerEnginePluginInfo::clientAtts  = new SurfaceAttributes;
        SurfaceViewerEnginePluginInfo::defaultAtts = new SurfaceAttributes;
    }
}

// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfaceViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfaceViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SurfaceAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SurfaceAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
SurfaceViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtSurfacePlot;
}

// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfaceViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(SurfaceAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: SurfaceViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfaceViewerEnginePluginInfo::GetMenuName() const
{
    return "Surface";
}

