// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SurfaceScriptingPluginInfo.C
// ************************************************************************* //
#include <PySurfaceAttributes.h>
#include <SurfacePluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Surface,Scripting)

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SurfaceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySurfaceAttributes_StartUp((SurfaceAttributes *)subj, data);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SurfaceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySurfaceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Surface plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SurfaceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySurfaceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SurfaceScriptingPluginInfo::GetLogString()
{
    std::string s(PySurfaceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SurfaceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SurfaceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySurfaceAttributes_SetDefaults((const SurfaceAttributes *)atts);
}
