// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SubsetCommonPluginInfo.C
// ****************************************************************************

#include <SubsetPluginInfo.h>
#include <SubsetAttributes.h>

// ****************************************************************************
//  Method: SubsetCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SubsetCommonPluginInfo::AllocAttributes()
{
    return new SubsetAttributes;
}

// ****************************************************************************
//  Method: SubsetCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Subset attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SubsetCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SubsetAttributes *) to) = *((SubsetAttributes *) from);
}

// ****************************************************************************
// Method: SubsetCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
SubsetCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SUBSET | VAR_CATEGORY_MESH;
}

