// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SpreadsheetViewerPluginInfo.C
// ****************************************************************************

#include <SpreadsheetPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY_EV(Spreadsheet,Viewer)


// ****************************************************************************
//  Method: SpreadsheetViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Spreadsheet.xpm>
const char **
SpreadsheetViewerPluginInfo::XPMIconData() const
{
    return Spreadsheet_xpm;
}
// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayCreate
//
// Purpose:
//   Creates an alternate display that will display data for the Spreadsheet
//   plot.
//
// Arguments:
//   plot : Pointer to the ViewerPlot that will own the alternate display.
//
// Returns:    A pointer to the alternate display.
//
// Note:       We refer to the alternate display using void* so it can be
//             whatever type of display that is most appropriate Qt, X, ...
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:53:23 PDT 2007
//
// Modifications:
//   Brad Whitlock, Mon Aug 11 16:24:41 PDT 2008
//   Removed name argument from SpreadsheetViewer constructor.
//
// ****************************************************************************
#include <SpreadsheetViewer.h>
#include <avtCallback.h>
void *
SpreadsheetViewerPluginInfo::AlternateDisplayCreate(ViewerPlot *plot)
{
    void *dpy = 0;

    if(!avtCallback::GetNowinMode())
    {
        // We're not in nowin mode so create the spreadsheet viewer.
        SpreadsheetViewer *win = new SpreadsheetViewer(plot, 0);
        dpy = (void *)win;
    }

    return dpy;
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayDestroy
//
// Purpose:
//   This method is called when the alternate display must be destroyed.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetViewerPluginInfo::AlternateDisplayDestroy(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        delete v;
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayClear
//
// Purpose:
//   This method is called when the alternate display must be cleared of data.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetViewerPluginInfo::AlternateDisplayClear(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->clear();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayHide
//
// Purpose:
//   This method is called when the alternate display must be hidden.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetViewerPluginInfo::AlternateDisplayHide(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->hide();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayShow
//
// Purpose:
//   This method is called when the alternate display must be shown.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetViewerPluginInfo::AlternateDisplayShow(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        if(v->isMinimized())
            v->showNormal();
        else
            v->show();
        v->raise();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayIconify
//
// Purpose:
//   This method is called when the alternate display must be iconified.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetViewerPluginInfo::AlternateDisplayIconify(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->showMinimized();
    }
}

// ****************************************************************************
// Method: SpreadsheetViewerPluginInfo::AlternateDisplayDeIconify
//
// Purpose:
//   This method is called when the alternate display must be de-iconified.
//
// Arguments:
//   dpy : The handle to the alternate display.
//
// Programmer: Brad Whitlock
// Creation:   Wed Feb 21 10:55:03 PDT 2007
//
// Modifications:
//
// ****************************************************************************

void
SpreadsheetViewerPluginInfo::AlternateDisplayDeIconify(void *dpy)
{
    if(dpy != 0)
    {
        SpreadsheetViewer *v = (SpreadsheetViewer *)dpy;
        v->showNormal();
    }
}


