// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SpreadsheetPluginInfo.C
// ****************************************************************************

#include <SpreadsheetPluginInfo.h>
#include <SpreadsheetAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Spreadsheet,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Spreadsheet,General)

// ****************************************************************************
//  Method: SpreadsheetGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SpreadsheetGeneralPluginInfo::GetName() const
{
    return "Spreadsheet";
}

// ****************************************************************************
//  Method: SpreadsheetGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SpreadsheetGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: SpreadsheetGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SpreadsheetGeneralPluginInfo::GetID() const
{
    return "Spreadsheet_1.0";
}
// ****************************************************************************
//  Method: SpreadsheetGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SpreadsheetGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
