// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SpreadsheetGUIPluginInfo.C
// ****************************************************************************

#include <SpreadsheetPluginInfo.h>
#include <SpreadsheetAttributes.h>
#include <QApplication>
#include <QvisSpreadsheetPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Spreadsheet,GUI)

// ****************************************************************************
//  Method: SpreadsheetGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
SpreadsheetGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Spreadsheet"));
}


// ****************************************************************************
//  Method: SpreadsheetGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
SpreadsheetGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisSpreadsheetPlotWindow(type, (SpreadsheetAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: SpreadsheetGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Spreadsheet.xpm>
const char **
SpreadsheetGUIPluginInfo::XPMIconData() const
{
    return Spreadsheet_xpm;
}

