// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ScatterViewerEnginePluginInfo.C
// ****************************************************************************

#include <ScatterPluginInfo.h>
#include <avtScatterPlot.h>
#include <ScatterAttributes.h>

//
// Storage for static data elements.
//
ScatterAttributes *ScatterViewerEnginePluginInfo::clientAtts = NULL;
ScatterAttributes *ScatterViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ScatterViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ScatterViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (ScatterViewerEnginePluginInfo::clientAtts == NULL)
    {
        ScatterViewerEnginePluginInfo::clientAtts  = new ScatterAttributes;
        ScatterViewerEnginePluginInfo::defaultAtts = new ScatterAttributes;
    }
}

// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ScatterViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ScatterViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ScatterViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ScatterAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ScatterViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ScatterAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
ScatterViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtScatterPlot;
}

// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ScatterViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(ScatterAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: ScatterViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ScatterViewerEnginePluginInfo::GetMenuName() const
{
    return "Scatter";
}

