// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ScatterScriptingPluginInfo.C
// ************************************************************************* //
#include <PyScatterAttributes.h>
#include <ScatterPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Scatter,Scripting)

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ScatterScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyScatterAttributes_StartUp((ScatterAttributes *)subj, data);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ScatterScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyScatterAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Scatter plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ScatterScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyScatterAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ScatterScriptingPluginInfo::GetLogString()
{
    std::string s(PyScatterAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ScatterScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyScatterAttributes_SetDefaults((const ScatterAttributes *)atts);
}
