// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PseudocolorViewerEnginePluginInfo.C
// ****************************************************************************

#include <PseudocolorPluginInfo.h>
#include <avtPseudocolorPlot.h>
#include <PseudocolorAttributes.h>

//
// Storage for static data elements.
//
PseudocolorAttributes *PseudocolorViewerEnginePluginInfo::clientAtts = NULL;
PseudocolorAttributes *PseudocolorViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  PseudocolorViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
PseudocolorViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (PseudocolorViewerEnginePluginInfo::clientAtts == NULL)
    {
        PseudocolorViewerEnginePluginInfo::clientAtts  = new PseudocolorAttributes;
        PseudocolorViewerEnginePluginInfo::defaultAtts = new PseudocolorAttributes;
    }
}

// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PseudocolorViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PseudocolorViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PseudocolorViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(PseudocolorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PseudocolorViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(PseudocolorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
PseudocolorViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtPseudocolorPlot;
}

// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PseudocolorViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(PseudocolorAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: PseudocolorViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PseudocolorViewerEnginePluginInfo::GetMenuName() const
{
    return "Pseudocolor";
}

