// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PseudocolorGUIPluginInfo.C
// ****************************************************************************

#include <PseudocolorPluginInfo.h>
#include <PseudocolorAttributes.h>
#include <QApplication>
#include <QvisPseudocolorPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Pseudocolor,GUI)

// ****************************************************************************
//  Method: PseudocolorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
PseudocolorGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Pseudocolor"));
}


// ****************************************************************************
//  Method: PseudocolorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
PseudocolorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisPseudocolorPlotWindow(type, (PseudocolorAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: PseudocolorGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Pseudocolor.xpm>
const char **
PseudocolorGUIPluginInfo::XPMIconData() const
{
    return Pseudocolor_xpm;
}

