// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PseudocolorCommonPluginInfo.C
// ****************************************************************************

#include <PseudocolorPluginInfo.h>
#include <PseudocolorAttributes.h>

// ****************************************************************************
//  Method: PseudocolorCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PseudocolorCommonPluginInfo::AllocAttributes()
{
    return new PseudocolorAttributes;
}

// ****************************************************************************
//  Method: PseudocolorCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Pseudocolor attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PseudocolorCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((PseudocolorAttributes *) to) = *((PseudocolorAttributes *) from);
}

// ****************************************************************************
// Method: PseudocolorCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
PseudocolorCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}

