// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyParallelCoordinatesAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyParallelCoordinatesAttributes
//
// Purpose:
//   This class contains the plot attributes for the ParallelCoordinates plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ParallelCoordinatesAttributes.
//
struct ParallelCoordinatesAttributesObject
{
    PyObject_HEAD
    ParallelCoordinatesAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewParallelCoordinatesAttributes(int);

std::string
PyParallelCoordinatesAttributes_ToString(const ParallelCoordinatesAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &scalarAxisNames = atts->GetScalarAxisNames();
        snprintf(tmpStr, 1000, "%sscalarAxisNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < scalarAxisNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", scalarAxisNames[i].c_str());
            str += tmpStr;
            if(i < scalarAxisNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &visualAxisNames = atts->GetVisualAxisNames();
        snprintf(tmpStr, 1000, "%svisualAxisNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < visualAxisNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", visualAxisNames[i].c_str());
            str += tmpStr;
            if(i < visualAxisNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &extentMinima = atts->GetExtentMinima();
        snprintf(tmpStr, 1000, "%sextentMinima = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < extentMinima.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", extentMinima[i]);
            str += tmpStr;
            if(i < extentMinima.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &extentMaxima = atts->GetExtentMaxima();
        snprintf(tmpStr, 1000, "%sextentMaxima = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < extentMaxima.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", extentMaxima[i]);
            str += tmpStr;
            if(i < extentMaxima.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetDrawLines())
        snprintf(tmpStr, 1000, "%sdrawLines = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sdrawLines = 0\n", prefix);
    str += tmpStr;
    const unsigned char *linesColor = atts->GetLinesColor().GetColor();
    snprintf(tmpStr, 1000, "%slinesColor = (%d, %d, %d, %d)\n", prefix, int(linesColor[0]), int(linesColor[1]), int(linesColor[2]), int(linesColor[3]));
    str += tmpStr;
    if(atts->GetDrawContext())
        snprintf(tmpStr, 1000, "%sdrawContext = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sdrawContext = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scontextGamma = %g\n", prefix, atts->GetContextGamma());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scontextNumPartitions = %d\n", prefix, atts->GetContextNumPartitions());
    str += tmpStr;
    const unsigned char *contextColor = atts->GetContextColor().GetColor();
    snprintf(tmpStr, 1000, "%scontextColor = (%d, %d, %d, %d)\n", prefix, int(contextColor[0]), int(contextColor[1]), int(contextColor[2]), int(contextColor[3]));
    str += tmpStr;
    if(atts->GetDrawLinesOnlyIfExtentsOn())
        snprintf(tmpStr, 1000, "%sdrawLinesOnlyIfExtentsOn = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sdrawLinesOnlyIfExtentsOn = 0\n", prefix);
    str += tmpStr;
    if(atts->GetUnifyAxisExtents())
        snprintf(tmpStr, 1000, "%sunifyAxisExtents = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sunifyAxisExtents = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%slinesNumPartitions = %d\n", prefix, atts->GetLinesNumPartitions());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sfocusGamma = %g\n", prefix, atts->GetFocusGamma());
    str += tmpStr;
    const char *drawFocusAs_names = "IndividualLines, BinsOfConstantColor, BinsColoredByPopulation";
    switch (atts->GetDrawFocusAs())
    {
      case ParallelCoordinatesAttributes::IndividualLines:
          snprintf(tmpStr, 1000, "%sdrawFocusAs = %sIndividualLines  # %s\n", prefix, prefix, drawFocusAs_names);
          str += tmpStr;
          break;
      case ParallelCoordinatesAttributes::BinsOfConstantColor:
          snprintf(tmpStr, 1000, "%sdrawFocusAs = %sBinsOfConstantColor  # %s\n", prefix, prefix, drawFocusAs_names);
          str += tmpStr;
          break;
      case ParallelCoordinatesAttributes::BinsColoredByPopulation:
          snprintf(tmpStr, 1000, "%sdrawFocusAs = %sBinsColoredByPopulation  # %s\n", prefix, prefix, drawFocusAs_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
ParallelCoordinatesAttributes_Notify(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetScalarAxisNames(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    stringVector  &vec = obj->data->GetScalarAxisNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the scalarAxisNames in the object as modified.
    obj->data->SelectScalarAxisNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetScalarAxisNames(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the scalarAxisNames.
    const stringVector &scalarAxisNames = obj->data->GetScalarAxisNames();
    PyObject *retval = PyTuple_New(scalarAxisNames.size());
    for(size_t i = 0; i < scalarAxisNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(scalarAxisNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetVisualAxisNames(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    stringVector  &vec = obj->data->GetVisualAxisNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the visualAxisNames in the object as modified.
    obj->data->SelectVisualAxisNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetVisualAxisNames(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the visualAxisNames.
    const stringVector &visualAxisNames = obj->data->GetVisualAxisNames();
    PyObject *retval = PyTuple_New(visualAxisNames.size());
    for(size_t i = 0; i < visualAxisNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(visualAxisNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetExtentMinima(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    doubleVector  &vec = obj->data->GetExtentMinima();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the extentMinima in the object as modified.
    obj->data->SelectExtentMinima();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetExtentMinima(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the extentMinima.
    const doubleVector &extentMinima = obj->data->GetExtentMinima();
    PyObject *retval = PyTuple_New(extentMinima.size());
    for(size_t i = 0; i < extentMinima.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(extentMinima[i]));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetExtentMaxima(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    doubleVector  &vec = obj->data->GetExtentMaxima();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the extentMaxima in the object as modified.
    obj->data->SelectExtentMaxima();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetExtentMaxima(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the extentMaxima.
    const doubleVector &extentMaxima = obj->data->GetExtentMaxima();
    PyObject *retval = PyTuple_New(extentMaxima.size());
    for(size_t i = 0; i < extentMaxima.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(extentMaxima[i]));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetDrawLines(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawLines in the object.
    obj->data->SetDrawLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetDrawLines(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawLines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetLinesColor(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the linesColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetLinesColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetLinesColor(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the linesColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *linesColor = obj->data->GetLinesColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(linesColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(linesColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(linesColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(linesColor[3])));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetDrawContext(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawContext in the object.
    obj->data->SetDrawContext(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetDrawContext(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawContext()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetContextGamma(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the contextGamma in the object.
    obj->data->SetContextGamma(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetContextGamma(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetContextGamma()));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetContextNumPartitions(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the contextNumPartitions in the object.
    obj->data->SetContextNumPartitions((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetContextNumPartitions(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetContextNumPartitions()));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetContextColor(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the contextColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetContextColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetContextColor(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the contextColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *contextColor = obj->data->GetContextColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(contextColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(contextColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(contextColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(contextColor[3])));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetDrawLinesOnlyIfExtentsOn(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawLinesOnlyIfExtentsOn in the object.
    obj->data->SetDrawLinesOnlyIfExtentsOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetDrawLinesOnlyIfExtentsOn(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawLinesOnlyIfExtentsOn()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetUnifyAxisExtents(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the unifyAxisExtents in the object.
    obj->data->SetUnifyAxisExtents(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetUnifyAxisExtents(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUnifyAxisExtents()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetLinesNumPartitions(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the linesNumPartitions in the object.
    obj->data->SetLinesNumPartitions((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetLinesNumPartitions(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLinesNumPartitions()));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetFocusGamma(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the focusGamma in the object.
    obj->data->SetFocusGamma(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetFocusGamma(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetFocusGamma()));
    return retval;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_SetDrawFocusAs(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawFocusAs in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDrawFocusAs(ParallelCoordinatesAttributes::FocusRendering(ival));
    else
    {
        fprintf(stderr, "An invalid drawFocusAs value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "IndividualLines, BinsOfConstantColor, BinsColoredByPopulation.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ParallelCoordinatesAttributes_GetDrawFocusAs(PyObject *self, PyObject *args)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawFocusAs()));
    return retval;
}



PyMethodDef PyParallelCoordinatesAttributes_methods[PARALLELCOORDINATESATTRIBUTES_NMETH] = {
    {"Notify", ParallelCoordinatesAttributes_Notify, METH_VARARGS},
    {"SetScalarAxisNames", ParallelCoordinatesAttributes_SetScalarAxisNames, METH_VARARGS},
    {"GetScalarAxisNames", ParallelCoordinatesAttributes_GetScalarAxisNames, METH_VARARGS},
    {"SetVisualAxisNames", ParallelCoordinatesAttributes_SetVisualAxisNames, METH_VARARGS},
    {"GetVisualAxisNames", ParallelCoordinatesAttributes_GetVisualAxisNames, METH_VARARGS},
    {"SetExtentMinima", ParallelCoordinatesAttributes_SetExtentMinima, METH_VARARGS},
    {"GetExtentMinima", ParallelCoordinatesAttributes_GetExtentMinima, METH_VARARGS},
    {"SetExtentMaxima", ParallelCoordinatesAttributes_SetExtentMaxima, METH_VARARGS},
    {"GetExtentMaxima", ParallelCoordinatesAttributes_GetExtentMaxima, METH_VARARGS},
    {"SetDrawLines", ParallelCoordinatesAttributes_SetDrawLines, METH_VARARGS},
    {"GetDrawLines", ParallelCoordinatesAttributes_GetDrawLines, METH_VARARGS},
    {"SetLinesColor", ParallelCoordinatesAttributes_SetLinesColor, METH_VARARGS},
    {"GetLinesColor", ParallelCoordinatesAttributes_GetLinesColor, METH_VARARGS},
    {"SetDrawContext", ParallelCoordinatesAttributes_SetDrawContext, METH_VARARGS},
    {"GetDrawContext", ParallelCoordinatesAttributes_GetDrawContext, METH_VARARGS},
    {"SetContextGamma", ParallelCoordinatesAttributes_SetContextGamma, METH_VARARGS},
    {"GetContextGamma", ParallelCoordinatesAttributes_GetContextGamma, METH_VARARGS},
    {"SetContextNumPartitions", ParallelCoordinatesAttributes_SetContextNumPartitions, METH_VARARGS},
    {"GetContextNumPartitions", ParallelCoordinatesAttributes_GetContextNumPartitions, METH_VARARGS},
    {"SetContextColor", ParallelCoordinatesAttributes_SetContextColor, METH_VARARGS},
    {"GetContextColor", ParallelCoordinatesAttributes_GetContextColor, METH_VARARGS},
    {"SetDrawLinesOnlyIfExtentsOn", ParallelCoordinatesAttributes_SetDrawLinesOnlyIfExtentsOn, METH_VARARGS},
    {"GetDrawLinesOnlyIfExtentsOn", ParallelCoordinatesAttributes_GetDrawLinesOnlyIfExtentsOn, METH_VARARGS},
    {"SetUnifyAxisExtents", ParallelCoordinatesAttributes_SetUnifyAxisExtents, METH_VARARGS},
    {"GetUnifyAxisExtents", ParallelCoordinatesAttributes_GetUnifyAxisExtents, METH_VARARGS},
    {"SetLinesNumPartitions", ParallelCoordinatesAttributes_SetLinesNumPartitions, METH_VARARGS},
    {"GetLinesNumPartitions", ParallelCoordinatesAttributes_GetLinesNumPartitions, METH_VARARGS},
    {"SetFocusGamma", ParallelCoordinatesAttributes_SetFocusGamma, METH_VARARGS},
    {"GetFocusGamma", ParallelCoordinatesAttributes_GetFocusGamma, METH_VARARGS},
    {"SetDrawFocusAs", ParallelCoordinatesAttributes_SetDrawFocusAs, METH_VARARGS},
    {"GetDrawFocusAs", ParallelCoordinatesAttributes_GetDrawFocusAs, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ParallelCoordinatesAttributes_dealloc(PyObject *v)
{
   ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ParallelCoordinatesAttributes_compare(PyObject *v, PyObject *w)
{
    ParallelCoordinatesAttributes *a = ((ParallelCoordinatesAttributesObject *)v)->data;
    ParallelCoordinatesAttributes *b = ((ParallelCoordinatesAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyParallelCoordinatesAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "scalarAxisNames") == 0)
        return ParallelCoordinatesAttributes_GetScalarAxisNames(self, NULL);
    if(strcmp(name, "visualAxisNames") == 0)
        return ParallelCoordinatesAttributes_GetVisualAxisNames(self, NULL);
    if(strcmp(name, "extentMinima") == 0)
        return ParallelCoordinatesAttributes_GetExtentMinima(self, NULL);
    if(strcmp(name, "extentMaxima") == 0)
        return ParallelCoordinatesAttributes_GetExtentMaxima(self, NULL);
    if(strcmp(name, "drawLines") == 0)
        return ParallelCoordinatesAttributes_GetDrawLines(self, NULL);
    if(strcmp(name, "linesColor") == 0)
        return ParallelCoordinatesAttributes_GetLinesColor(self, NULL);
    if(strcmp(name, "drawContext") == 0)
        return ParallelCoordinatesAttributes_GetDrawContext(self, NULL);
    if(strcmp(name, "contextGamma") == 0)
        return ParallelCoordinatesAttributes_GetContextGamma(self, NULL);
    if(strcmp(name, "contextNumPartitions") == 0)
        return ParallelCoordinatesAttributes_GetContextNumPartitions(self, NULL);
    if(strcmp(name, "contextColor") == 0)
        return ParallelCoordinatesAttributes_GetContextColor(self, NULL);
    if(strcmp(name, "drawLinesOnlyIfExtentsOn") == 0)
        return ParallelCoordinatesAttributes_GetDrawLinesOnlyIfExtentsOn(self, NULL);
    if(strcmp(name, "unifyAxisExtents") == 0)
        return ParallelCoordinatesAttributes_GetUnifyAxisExtents(self, NULL);
    if(strcmp(name, "linesNumPartitions") == 0)
        return ParallelCoordinatesAttributes_GetLinesNumPartitions(self, NULL);
    if(strcmp(name, "focusGamma") == 0)
        return ParallelCoordinatesAttributes_GetFocusGamma(self, NULL);
    if(strcmp(name, "drawFocusAs") == 0)
        return ParallelCoordinatesAttributes_GetDrawFocusAs(self, NULL);
    if(strcmp(name, "IndividualLines") == 0)
        return PyInt_FromLong(long(ParallelCoordinatesAttributes::IndividualLines));
    if(strcmp(name, "BinsOfConstantColor") == 0)
        return PyInt_FromLong(long(ParallelCoordinatesAttributes::BinsOfConstantColor));
    if(strcmp(name, "BinsColoredByPopulation") == 0)
        return PyInt_FromLong(long(ParallelCoordinatesAttributes::BinsColoredByPopulation));


    return Py_FindMethod(PyParallelCoordinatesAttributes_methods, self, name);
}

int
PyParallelCoordinatesAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "scalarAxisNames") == 0)
        obj = ParallelCoordinatesAttributes_SetScalarAxisNames(self, tuple);
    else if(strcmp(name, "visualAxisNames") == 0)
        obj = ParallelCoordinatesAttributes_SetVisualAxisNames(self, tuple);
    else if(strcmp(name, "extentMinima") == 0)
        obj = ParallelCoordinatesAttributes_SetExtentMinima(self, tuple);
    else if(strcmp(name, "extentMaxima") == 0)
        obj = ParallelCoordinatesAttributes_SetExtentMaxima(self, tuple);
    else if(strcmp(name, "drawLines") == 0)
        obj = ParallelCoordinatesAttributes_SetDrawLines(self, tuple);
    else if(strcmp(name, "linesColor") == 0)
        obj = ParallelCoordinatesAttributes_SetLinesColor(self, tuple);
    else if(strcmp(name, "drawContext") == 0)
        obj = ParallelCoordinatesAttributes_SetDrawContext(self, tuple);
    else if(strcmp(name, "contextGamma") == 0)
        obj = ParallelCoordinatesAttributes_SetContextGamma(self, tuple);
    else if(strcmp(name, "contextNumPartitions") == 0)
        obj = ParallelCoordinatesAttributes_SetContextNumPartitions(self, tuple);
    else if(strcmp(name, "contextColor") == 0)
        obj = ParallelCoordinatesAttributes_SetContextColor(self, tuple);
    else if(strcmp(name, "drawLinesOnlyIfExtentsOn") == 0)
        obj = ParallelCoordinatesAttributes_SetDrawLinesOnlyIfExtentsOn(self, tuple);
    else if(strcmp(name, "unifyAxisExtents") == 0)
        obj = ParallelCoordinatesAttributes_SetUnifyAxisExtents(self, tuple);
    else if(strcmp(name, "linesNumPartitions") == 0)
        obj = ParallelCoordinatesAttributes_SetLinesNumPartitions(self, tuple);
    else if(strcmp(name, "focusGamma") == 0)
        obj = ParallelCoordinatesAttributes_SetFocusGamma(self, tuple);
    else if(strcmp(name, "drawFocusAs") == 0)
        obj = ParallelCoordinatesAttributes_SetDrawFocusAs(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ParallelCoordinatesAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)v;
    fprintf(fp, "%s", PyParallelCoordinatesAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ParallelCoordinatesAttributes_str(PyObject *v)
{
    ParallelCoordinatesAttributesObject *obj = (ParallelCoordinatesAttributesObject *)v;
    return PyString_FromString(PyParallelCoordinatesAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ParallelCoordinatesAttributes_Purpose = "This class contains the plot attributes for the ParallelCoordinates plot.";
#else
static char *ParallelCoordinatesAttributes_Purpose = "This class contains the plot attributes for the ParallelCoordinates plot.";
#endif

//
// The type description structure
//
static PyTypeObject ParallelCoordinatesAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ParallelCoordinatesAttributes",                    // tp_name
    sizeof(ParallelCoordinatesAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ParallelCoordinatesAttributes_dealloc,  // tp_dealloc
    (printfunc)ParallelCoordinatesAttributes_print,     // tp_print
    (getattrfunc)PyParallelCoordinatesAttributes_getattr, // tp_getattr
    (setattrfunc)PyParallelCoordinatesAttributes_setattr, // tp_setattr
    (cmpfunc)ParallelCoordinatesAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ParallelCoordinatesAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ParallelCoordinatesAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ParallelCoordinatesAttributes *defaultAtts = 0;
static ParallelCoordinatesAttributes *currentAtts = 0;

static PyObject *
NewParallelCoordinatesAttributes(int useCurrent)
{
    ParallelCoordinatesAttributesObject *newObject;
    newObject = PyObject_NEW(ParallelCoordinatesAttributesObject, &ParallelCoordinatesAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ParallelCoordinatesAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ParallelCoordinatesAttributes(*defaultAtts);
    else
        newObject->data = new ParallelCoordinatesAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapParallelCoordinatesAttributes(const ParallelCoordinatesAttributes *attr)
{
    ParallelCoordinatesAttributesObject *newObject;
    newObject = PyObject_NEW(ParallelCoordinatesAttributesObject, &ParallelCoordinatesAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ParallelCoordinatesAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ParallelCoordinatesAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewParallelCoordinatesAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ParallelCoordinatesAttributesMethods[] = {
    {"ParallelCoordinatesAttributes", ParallelCoordinatesAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ParallelCoordinatesAttributesObserver = 0;

std::string
PyParallelCoordinatesAttributes_GetLogString()
{
    std::string s("ParallelCoordinatesAtts = ParallelCoordinatesAttributes()\n");
    if(currentAtts != 0)
        s += PyParallelCoordinatesAttributes_ToString(currentAtts, "ParallelCoordinatesAtts.");
    return s;
}

static void
PyParallelCoordinatesAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ParallelCoordinatesAtts = ParallelCoordinatesAttributes()\n");
        s += PyParallelCoordinatesAttributes_ToString(currentAtts, "ParallelCoordinatesAtts.");
        cb(s);
    }
}

void
PyParallelCoordinatesAttributes_StartUp(ParallelCoordinatesAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyParallelCoordinatesAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ParallelCoordinatesAttributesObserver == 0)
    {
        ParallelCoordinatesAttributesObserver = new ObserverToCallback(subj,
            PyParallelCoordinatesAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyParallelCoordinatesAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ParallelCoordinatesAttributesObserver;
    ParallelCoordinatesAttributesObserver = 0;
}

PyMethodDef *
PyParallelCoordinatesAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ParallelCoordinatesAttributesMethods;
}

bool
PyParallelCoordinatesAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ParallelCoordinatesAttributesType);
}

ParallelCoordinatesAttributes *
PyParallelCoordinatesAttributes_FromPyObject(PyObject *obj)
{
    ParallelCoordinatesAttributesObject *obj2 = (ParallelCoordinatesAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyParallelCoordinatesAttributes_New()
{
    return NewParallelCoordinatesAttributes(0);
}

PyObject *
PyParallelCoordinatesAttributes_Wrap(const ParallelCoordinatesAttributes *attr)
{
    return WrapParallelCoordinatesAttributes(attr);
}

void
PyParallelCoordinatesAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ParallelCoordinatesAttributesObject *obj2 = (ParallelCoordinatesAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyParallelCoordinatesAttributes_SetDefaults(const ParallelCoordinatesAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ParallelCoordinatesAttributes(*atts);
}

