// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ParallelCoordinatesCommonPluginInfo.C
// ****************************************************************************

#include <ParallelCoordinatesPluginInfo.h>
#include <ParallelCoordinatesAttributes.h>

// ****************************************************************************
//  Method: ParallelCoordinatesCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ParallelCoordinatesCommonPluginInfo::AllocAttributes()
{
    return new ParallelCoordinatesAttributes;
}

// ****************************************************************************
//  Method: ParallelCoordinatesCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a ParallelCoordinates attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ParallelCoordinatesCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ParallelCoordinatesAttributes *) to) = *((ParallelCoordinatesAttributes *) from);
}

// ****************************************************************************
// Method: ParallelCoordinatesCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
ParallelCoordinatesCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_CURVE | VAR_CATEGORY_ARRAY;
}

