// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MultiCurveViewerEnginePluginInfo.C
// ****************************************************************************

#include <MultiCurvePluginInfo.h>
#include <avtMultiCurvePlot.h>
#include <MultiCurveAttributes.h>

//
// Storage for static data elements.
//
MultiCurveAttributes *MultiCurveViewerEnginePluginInfo::clientAtts = NULL;
MultiCurveAttributes *MultiCurveViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
// Method:  MultiCurveViewerEnginePluginInfo::InitializeGlobalObjects
//
// Purpose:
//   Initialize the plot atts.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//
// ****************************************************************************
void
MultiCurveViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (MultiCurveViewerEnginePluginInfo::clientAtts == NULL)
    {
        MultiCurveViewerEnginePluginInfo::clientAtts  = new MultiCurveAttributes;
        MultiCurveViewerEnginePluginInfo::defaultAtts = new MultiCurveAttributes;
    }

    InitializeDefaultPalette(clientAtts);
    InitializeDefaultPalette(defaultAtts);
}


// ****************************************************************************
//  Method: MultiCurveViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MultiCurveViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: MultiCurveViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MultiCurveViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: MultiCurveViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MultiCurveViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(MultiCurveAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: MultiCurveViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MultiCurveViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(MultiCurveAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: MultiCurveViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
MultiCurveViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtMultiCurvePlot;
}

// ****************************************************************************
// Method: MultiCurveViewerEnginePluginInfo::InitializePlotAtts
//
// Purpose:
//   Initialize the plot attributes to the default attributes.
//
// Arguments:
//   atts       The attribute subject to initialize.
//   plot       The viewer plot whose attributes are getting initialized.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//
// ****************************************************************************

void
MultiCurveViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    MultiCurveAttributes *multiCurve = (MultiCurveAttributes *)atts;
    *multiCurve = *defaultAtts;

    // Set the defaultPalette for the plot.
    InitializeDefaultPalette(multiCurve);
}

// ****************************************************************************
//  Method: MultiCurveViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiCurveViewerEnginePluginInfo::GetMenuName() const
{
    return "MultiCurve";
}

// ****************************************************************************
// Method: MultiCurveViewerEnginePluginInfo::InitializeDefaultPalette
//
// Purpose:
//   Initializes the default palette in the multiCurve attributes using the
//   default discrete color table.
//
// Arguments:
//   multiCurve The MultiCurveAttributes to initialize.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//   Eric Brugger, Tue Jan 20 12:19:28 PST 2009
//   I added code to enlarge the multi color field to 16 entries so that
//   clients may set them.
//
// ****************************************************************************
#include <avtColorTables.h>
#include <ColorTableAttributes.h>
void
MultiCurveViewerEnginePluginInfo::InitializeDefaultPalette(
    MultiCurveAttributes *multiCurve)
{
    // Copy over the multiCurve's defaultPalette with the default discrete
    // color table from avtColorTable.
    if (multiCurve->GetColorType() != MultiCurveAttributes::ColorByMultipleColors ||
        multiCurve->GetDefaultPalette().GetNumControlPoints() < 1)
    {
        avtColorTables *ct = avtColorTables::Instance();
        ColorTableAttributes *ctAtts = ct->GetColorTables();
        int i = ctAtts->GetColorTableIndex(ct->GetDefaultDiscreteColorTable());
        if(i != -1)
        {
            multiCurve->SetDefaultPalette(ctAtts->operator[](i));
        }
    }
    multiCurve->EnlargeMultiColor(16);
}

