// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  MultiCurveScriptingPluginInfo.C
// ************************************************************************* //
#include <PyMultiCurveAttributes.h>
#include <MultiCurvePluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(MultiCurve,Scripting)

// ****************************************************************************
// Method: MultiCurveScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MultiCurveScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyMultiCurveAttributes_StartUp((MultiCurveAttributes *)subj, data);
}

// ****************************************************************************
// Method: MultiCurveScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
MultiCurveScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyMultiCurveAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: MultiCurveScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is MultiCurve plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MultiCurveScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyMultiCurveAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: MultiCurveScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
MultiCurveScriptingPluginInfo::GetLogString()
{
    std::string s(PyMultiCurveAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: MultiCurveScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MultiCurveScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyMultiCurveAttributes_SetDefaults((const MultiCurveAttributes *)atts);
}
