// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MultiCurvePluginInfo.C
// ****************************************************************************

#include <MultiCurvePluginInfo.h>
#include <MultiCurveAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(MultiCurve,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(MultiCurve,General)

// ****************************************************************************
//  Method: MultiCurveGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiCurveGeneralPluginInfo::GetName() const
{
    return "MultiCurve";
}

// ****************************************************************************
//  Method: MultiCurveGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiCurveGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: MultiCurveGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MultiCurveGeneralPluginInfo::GetID() const
{
    return "MultiCurve_1.0";
}
// ****************************************************************************
//  Method: MultiCurveGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
MultiCurveGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
