// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MultiCurveCommonPluginInfo.C
// ****************************************************************************

#include <MultiCurvePluginInfo.h>
#include <MultiCurveAttributes.h>

// ****************************************************************************
//  Method: MultiCurveCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MultiCurveCommonPluginInfo::AllocAttributes()
{
    return new MultiCurveAttributes;
}

// ****************************************************************************
//  Method: MultiCurveCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a MultiCurve attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MultiCurveCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((MultiCurveAttributes *) to) = *((MultiCurveAttributes *) from);
}

// ****************************************************************************
// Method: MultiCurveCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
MultiCurveCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

