// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  MoleculeScriptingPluginInfo.C
// ************************************************************************* //
#include <PyMoleculeAttributes.h>
#include <MoleculePluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Molecule,Scripting)

// ****************************************************************************
// Method: MoleculeScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MoleculeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyMoleculeAttributes_StartUp((MoleculeAttributes *)subj, data);
}

// ****************************************************************************
// Method: MoleculeScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
MoleculeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyMoleculeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: MoleculeScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Molecule plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
MoleculeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyMoleculeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: MoleculeScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
MoleculeScriptingPluginInfo::GetLogString()
{
    std::string s(PyMoleculeAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: MoleculeScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
MoleculeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyMoleculeAttributes_SetDefaults((const MoleculeAttributes *)atts);
}
