// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MoleculeCommonPluginInfo.C
// ****************************************************************************

#include <MoleculePluginInfo.h>
#include <MoleculeAttributes.h>

// ****************************************************************************
//  Method: MoleculeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MoleculeCommonPluginInfo::AllocAttributes()
{
    return new MoleculeAttributes;
}

// ****************************************************************************
//  Method: MoleculeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Molecule attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MoleculeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((MoleculeAttributes *) to) = *((MoleculeAttributes *) from);
}

// ****************************************************************************
// Method: MoleculeCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
MoleculeCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

