// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MeshViewerEnginePluginInfo.C
// ****************************************************************************

#include <MeshPluginInfo.h>
#include <avtMeshPlot.h>
#include <MeshAttributes.h>

//
// Storage for static data elements.
//
MeshAttributes *MeshViewerEnginePluginInfo::clientAtts = NULL;
MeshAttributes *MeshViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  MeshViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
MeshViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (MeshViewerEnginePluginInfo::clientAtts == NULL)
    {
        MeshViewerEnginePluginInfo::clientAtts  = new MeshAttributes;
        MeshViewerEnginePluginInfo::defaultAtts = new MeshAttributes;
    }
}

// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MeshViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MeshViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MeshViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(MeshAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MeshViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(MeshAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
MeshViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtMeshPlot;
}

// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MeshViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(MeshAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: MeshViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MeshViewerEnginePluginInfo::GetMenuName() const
{
    return "Mesh";
}

