// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MeshPluginInfo.C
// ****************************************************************************

#include <MeshPluginInfo.h>
#include <MeshAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Mesh,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Mesh,General)

// ****************************************************************************
//  Method: MeshGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MeshGeneralPluginInfo::GetName() const
{
    return "Mesh";
}

// ****************************************************************************
//  Method: MeshGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MeshGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: MeshGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MeshGeneralPluginInfo::GetID() const
{
    return "Mesh_1.0";
}
// ****************************************************************************
//  Method: MeshGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
MeshGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
