// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyLabelAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <PyColorAttribute.h>
#include <PyFontAttributes.h>
#include <PyFontAttributes.h>

// ****************************************************************************
// Module: PyLabelAttributes
//
// Purpose:
//   This class contains the fields that we need to set the attributes for the Label plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LabelAttributes.
//
struct LabelAttributesObject
{
    PyObject_HEAD
    LabelAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLabelAttributes(int);

std::string
PyLabelAttributes_ToString(const LabelAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetLegendFlag())
        snprintf(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowNodes())
        snprintf(tmpStr, 1000, "%sshowNodes = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowNodes = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowCells())
        snprintf(tmpStr, 1000, "%sshowCells = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowCells = 0\n", prefix);
    str += tmpStr;
    if(atts->GetRestrictNumberOfLabels())
        snprintf(tmpStr, 1000, "%srestrictNumberOfLabels = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%srestrictNumberOfLabels = 0\n", prefix);
    str += tmpStr;
    const char *drawLabelsFacing_names = "Front, Back, FrontAndBack";
    switch (atts->GetDrawLabelsFacing())
    {
      case LabelAttributes::Front:
          snprintf(tmpStr, 1000, "%sdrawLabelsFacing = %sFront  # %s\n", prefix, prefix, drawLabelsFacing_names);
          str += tmpStr;
          break;
      case LabelAttributes::Back:
          snprintf(tmpStr, 1000, "%sdrawLabelsFacing = %sBack  # %s\n", prefix, prefix, drawLabelsFacing_names);
          str += tmpStr;
          break;
      case LabelAttributes::FrontAndBack:
          snprintf(tmpStr, 1000, "%sdrawLabelsFacing = %sFrontAndBack  # %s\n", prefix, prefix, drawLabelsFacing_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *labelDisplayFormat_names = "Natural, LogicalIndex, Index";
    switch (atts->GetLabelDisplayFormat())
    {
      case LabelAttributes::Natural:
          snprintf(tmpStr, 1000, "%slabelDisplayFormat = %sNatural  # %s\n", prefix, prefix, labelDisplayFormat_names);
          str += tmpStr;
          break;
      case LabelAttributes::LogicalIndex:
          snprintf(tmpStr, 1000, "%slabelDisplayFormat = %sLogicalIndex  # %s\n", prefix, prefix, labelDisplayFormat_names);
          str += tmpStr;
          break;
      case LabelAttributes::Index:
          snprintf(tmpStr, 1000, "%slabelDisplayFormat = %sIndex  # %s\n", prefix, prefix, labelDisplayFormat_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%snumberOfLabels = %d\n", prefix, atts->GetNumberOfLabels());
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "textFont1.";
        str += PyFontAttributes_ToString(&atts->GetTextFont1(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "textFont2.";
        str += PyFontAttributes_ToString(&atts->GetTextFont2(), objPrefix.c_str());
    }
    const char *horizontalJustification_names = "HCenter, Left, Right";
    switch (atts->GetHorizontalJustification())
    {
      case LabelAttributes::HCenter:
          snprintf(tmpStr, 1000, "%shorizontalJustification = %sHCenter  # %s\n", prefix, prefix, horizontalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Left:
          snprintf(tmpStr, 1000, "%shorizontalJustification = %sLeft  # %s\n", prefix, prefix, horizontalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Right:
          snprintf(tmpStr, 1000, "%shorizontalJustification = %sRight  # %s\n", prefix, prefix, horizontalJustification_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *verticalJustification_names = "VCenter, Top, Bottom";
    switch (atts->GetVerticalJustification())
    {
      case LabelAttributes::VCenter:
          snprintf(tmpStr, 1000, "%sverticalJustification = %sVCenter  # %s\n", prefix, prefix, verticalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Top:
          snprintf(tmpStr, 1000, "%sverticalJustification = %sTop  # %s\n", prefix, prefix, verticalJustification_names);
          str += tmpStr;
          break;
      case LabelAttributes::Bottom:
          snprintf(tmpStr, 1000, "%sverticalJustification = %sBottom  # %s\n", prefix, prefix, verticalJustification_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *depthTestMode_names = "LABEL_DT_AUTO, LABEL_DT_ALWAYS, LABEL_DT_NEVER";
    switch (atts->GetDepthTestMode())
    {
      case LabelAttributes::LABEL_DT_AUTO:
          snprintf(tmpStr, 1000, "%sdepthTestMode = %sLABEL_DT_AUTO  # %s\n", prefix, prefix, depthTestMode_names);
          str += tmpStr;
          break;
      case LabelAttributes::LABEL_DT_ALWAYS:
          snprintf(tmpStr, 1000, "%sdepthTestMode = %sLABEL_DT_ALWAYS  # %s\n", prefix, prefix, depthTestMode_names);
          str += tmpStr;
          break;
      case LabelAttributes::LABEL_DT_NEVER:
          snprintf(tmpStr, 1000, "%sdepthTestMode = %sLABEL_DT_NEVER  # %s\n", prefix, prefix, depthTestMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sformatTemplate = \"%s\"\n", prefix, atts->GetFormatTemplate().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
LabelAttributes_Notify(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetShowNodes(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodes in the object.
    obj->data->SetShowNodes(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetShowNodes(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodes()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetShowCells(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showCells in the object.
    obj->data->SetShowCells(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetShowCells(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowCells()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetRestrictNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the restrictNumberOfLabels in the object.
    obj->data->SetRestrictNumberOfLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetRestrictNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRestrictNumberOfLabels()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetDrawLabelsFacing(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawLabelsFacing in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDrawLabelsFacing(LabelAttributes::LabelDrawFacing(ival));
    else
    {
        fprintf(stderr, "An invalid drawLabelsFacing value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Front, Back, FrontAndBack.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetDrawLabelsFacing(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawLabelsFacing()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetLabelDisplayFormat(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the labelDisplayFormat in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetLabelDisplayFormat(LabelAttributes::LabelIndexDisplay(ival));
    else
    {
        fprintf(stderr, "An invalid labelDisplayFormat value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Natural, LogicalIndex, Index.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetLabelDisplayFormat(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLabelDisplayFormat()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfLabels in the object.
    obj->data->SetNumberOfLabels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfLabels()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetTextFont1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyFontAttributes_Check(newValue))
    {
        fprintf(stderr, "The textFont1 field can only be set with FontAttributes objects.\n");
        return NULL;
    }

    obj->data->SetTextFont1(*PyFontAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetTextFont1(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyFontAttributes_Wrap(&obj->data->GetTextFont1());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyFontAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetTextFont2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyFontAttributes_Check(newValue))
    {
        fprintf(stderr, "The textFont2 field can only be set with FontAttributes objects.\n");
        return NULL;
    }

    obj->data->SetTextFont2(*PyFontAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetTextFont2(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyFontAttributes_Wrap(&obj->data->GetTextFont2());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyFontAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetHorizontalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the horizontalJustification in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetHorizontalJustification(LabelAttributes::LabelHorizontalAlignment(ival));
    else
    {
        fprintf(stderr, "An invalid horizontalJustification value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "HCenter, Left, Right.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetHorizontalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHorizontalJustification()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetVerticalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the verticalJustification in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVerticalJustification(LabelAttributes::LabelVerticalAlignment(ival));
    else
    {
        fprintf(stderr, "An invalid verticalJustification value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "VCenter, Top, Bottom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetVerticalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVerticalJustification()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetDepthTestMode(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the depthTestMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDepthTestMode(LabelAttributes::DepthTestMode(ival));
    else
    {
        fprintf(stderr, "An invalid depthTestMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "LABEL_DT_AUTO, LABEL_DT_ALWAYS, LABEL_DT_NEVER.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetDepthTestMode(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDepthTestMode()));
    return retval;
}

/*static*/ PyObject *
LabelAttributes_SetFormatTemplate(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the formatTemplate in the object.
    obj->data->SetFormatTemplate(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LabelAttributes_GetFormatTemplate(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFormatTemplate().c_str());
    return retval;
}



PyMethodDef PyLabelAttributes_methods[LABELATTRIBUTES_NMETH] = {
    {"Notify", LabelAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", LabelAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", LabelAttributes_GetLegendFlag, METH_VARARGS},
    {"SetShowNodes", LabelAttributes_SetShowNodes, METH_VARARGS},
    {"GetShowNodes", LabelAttributes_GetShowNodes, METH_VARARGS},
    {"SetShowCells", LabelAttributes_SetShowCells, METH_VARARGS},
    {"GetShowCells", LabelAttributes_GetShowCells, METH_VARARGS},
    {"SetRestrictNumberOfLabels", LabelAttributes_SetRestrictNumberOfLabels, METH_VARARGS},
    {"GetRestrictNumberOfLabels", LabelAttributes_GetRestrictNumberOfLabels, METH_VARARGS},
    {"SetDrawLabelsFacing", LabelAttributes_SetDrawLabelsFacing, METH_VARARGS},
    {"GetDrawLabelsFacing", LabelAttributes_GetDrawLabelsFacing, METH_VARARGS},
    {"SetLabelDisplayFormat", LabelAttributes_SetLabelDisplayFormat, METH_VARARGS},
    {"GetLabelDisplayFormat", LabelAttributes_GetLabelDisplayFormat, METH_VARARGS},
    {"SetNumberOfLabels", LabelAttributes_SetNumberOfLabels, METH_VARARGS},
    {"GetNumberOfLabels", LabelAttributes_GetNumberOfLabels, METH_VARARGS},
    {"SetTextFont1", LabelAttributes_SetTextFont1, METH_VARARGS},
    {"GetTextFont1", LabelAttributes_GetTextFont1, METH_VARARGS},
    {"SetTextFont2", LabelAttributes_SetTextFont2, METH_VARARGS},
    {"GetTextFont2", LabelAttributes_GetTextFont2, METH_VARARGS},
    {"SetHorizontalJustification", LabelAttributes_SetHorizontalJustification, METH_VARARGS},
    {"GetHorizontalJustification", LabelAttributes_GetHorizontalJustification, METH_VARARGS},
    {"SetVerticalJustification", LabelAttributes_SetVerticalJustification, METH_VARARGS},
    {"GetVerticalJustification", LabelAttributes_GetVerticalJustification, METH_VARARGS},
    {"SetDepthTestMode", LabelAttributes_SetDepthTestMode, METH_VARARGS},
    {"GetDepthTestMode", LabelAttributes_GetDepthTestMode, METH_VARARGS},
    {"SetFormatTemplate", LabelAttributes_SetFormatTemplate, METH_VARARGS},
    {"GetFormatTemplate", LabelAttributes_GetFormatTemplate, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LabelAttributes_dealloc(PyObject *v)
{
   LabelAttributesObject *obj = (LabelAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LabelAttributes_compare(PyObject *v, PyObject *w)
{
    LabelAttributes *a = ((LabelAttributesObject *)v)->data;
    LabelAttributes *b = ((LabelAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLabelAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return LabelAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "showNodes") == 0)
        return LabelAttributes_GetShowNodes(self, NULL);
    if(strcmp(name, "showCells") == 0)
        return LabelAttributes_GetShowCells(self, NULL);
    if(strcmp(name, "restrictNumberOfLabels") == 0)
        return LabelAttributes_GetRestrictNumberOfLabels(self, NULL);
    if(strcmp(name, "drawLabelsFacing") == 0)
        return LabelAttributes_GetDrawLabelsFacing(self, NULL);
    if(strcmp(name, "Front") == 0)
        return PyInt_FromLong(long(LabelAttributes::Front));
    if(strcmp(name, "Back") == 0)
        return PyInt_FromLong(long(LabelAttributes::Back));
    if(strcmp(name, "FrontAndBack") == 0)
        return PyInt_FromLong(long(LabelAttributes::FrontAndBack));

    if(strcmp(name, "labelDisplayFormat") == 0)
        return LabelAttributes_GetLabelDisplayFormat(self, NULL);
    if(strcmp(name, "Natural") == 0)
        return PyInt_FromLong(long(LabelAttributes::Natural));
    if(strcmp(name, "LogicalIndex") == 0)
        return PyInt_FromLong(long(LabelAttributes::LogicalIndex));
    if(strcmp(name, "Index") == 0)
        return PyInt_FromLong(long(LabelAttributes::Index));

    if(strcmp(name, "numberOfLabels") == 0)
        return LabelAttributes_GetNumberOfLabels(self, NULL);
    if(strcmp(name, "textFont1") == 0)
        return LabelAttributes_GetTextFont1(self, NULL);
    if(strcmp(name, "textFont2") == 0)
        return LabelAttributes_GetTextFont2(self, NULL);
    if(strcmp(name, "horizontalJustification") == 0)
        return LabelAttributes_GetHorizontalJustification(self, NULL);
    if(strcmp(name, "HCenter") == 0)
        return PyInt_FromLong(long(LabelAttributes::HCenter));
    if(strcmp(name, "Left") == 0)
        return PyInt_FromLong(long(LabelAttributes::Left));
    if(strcmp(name, "Right") == 0)
        return PyInt_FromLong(long(LabelAttributes::Right));

    if(strcmp(name, "verticalJustification") == 0)
        return LabelAttributes_GetVerticalJustification(self, NULL);
    if(strcmp(name, "VCenter") == 0)
        return PyInt_FromLong(long(LabelAttributes::VCenter));
    if(strcmp(name, "Top") == 0)
        return PyInt_FromLong(long(LabelAttributes::Top));
    if(strcmp(name, "Bottom") == 0)
        return PyInt_FromLong(long(LabelAttributes::Bottom));

    if(strcmp(name, "depthTestMode") == 0)
        return LabelAttributes_GetDepthTestMode(self, NULL);
    if(strcmp(name, "LABEL_DT_AUTO") == 0)
        return PyInt_FromLong(long(LabelAttributes::LABEL_DT_AUTO));
    if(strcmp(name, "LABEL_DT_ALWAYS") == 0)
        return PyInt_FromLong(long(LabelAttributes::LABEL_DT_ALWAYS));
    if(strcmp(name, "LABEL_DT_NEVER") == 0)
        return PyInt_FromLong(long(LabelAttributes::LABEL_DT_NEVER));

    if(strcmp(name, "formatTemplate") == 0)
        return LabelAttributes_GetFormatTemplate(self, NULL);

    return Py_FindMethod(PyLabelAttributes_methods, self, name);
}

int
PyLabelAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "legendFlag") == 0)
        obj = LabelAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "showNodes") == 0)
        obj = LabelAttributes_SetShowNodes(self, tuple);
    else if(strcmp(name, "showCells") == 0)
        obj = LabelAttributes_SetShowCells(self, tuple);
    else if(strcmp(name, "restrictNumberOfLabels") == 0)
        obj = LabelAttributes_SetRestrictNumberOfLabels(self, tuple);
    else if(strcmp(name, "drawLabelsFacing") == 0)
        obj = LabelAttributes_SetDrawLabelsFacing(self, tuple);
    else if(strcmp(name, "labelDisplayFormat") == 0)
        obj = LabelAttributes_SetLabelDisplayFormat(self, tuple);
    else if(strcmp(name, "numberOfLabels") == 0)
        obj = LabelAttributes_SetNumberOfLabels(self, tuple);
    else if(strcmp(name, "textFont1") == 0)
        obj = LabelAttributes_SetTextFont1(self, tuple);
    else if(strcmp(name, "textFont2") == 0)
        obj = LabelAttributes_SetTextFont2(self, tuple);
    else if(strcmp(name, "horizontalJustification") == 0)
        obj = LabelAttributes_SetHorizontalJustification(self, tuple);
    else if(strcmp(name, "verticalJustification") == 0)
        obj = LabelAttributes_SetVerticalJustification(self, tuple);
    else if(strcmp(name, "depthTestMode") == 0)
        obj = LabelAttributes_SetDepthTestMode(self, tuple);
    else if(strcmp(name, "formatTemplate") == 0)
        obj = LabelAttributes_SetFormatTemplate(self, tuple);

    // Try to handle legacy fields
    if(obj == NULL)
    {
#define GETCOLOR if(!PyArg_ParseTuple(tuple, "iiii", &c[0], &c[1], &c[2], &c[3])) \
    { \
        c[3] = 255; \
        if(!PyArg_ParseTuple(tuple, "iii", &c[0], &c[1], &c[2])) \
        { \
            double dr, dg, db, da; \
            if(PyArg_ParseTuple(tuple, "dddd", &dr, &dg, &db, &da)) \
            { \
                c[0] = int(dr); \
                c[1] = int(dg); \
                c[2] = int(db); \
                c[3] = int(da); \
            } \
            else if(PyArg_ParseTuple(tuple, "ddd", &dr, &dg, &db)) \
            { \
                c[0] = int(dr); \
                c[1] = int(dg); \
                c[2] = int(db); \
                c[3] = 255; \
            } \
            else \
            { \
                PyObject *obj = NULL; \
                if(!PyArg_ParseTuple(tuple, "O", &obj)) \
                    success = false; \
                if(!PyTuple_Check(obj)) \
                    success = false; \
                if(PyTuple_Size(obj) < 3 || PyTuple_Size(obj) > 4) \
                    success = false; \
                for(int i = 0; i < PyTuple_Size(obj); ++i) \
                { \
                    PyObject *item = PyTuple_GET_ITEM(obj, i); \
                    if(PyInt_Check(item)) \
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(obj, i))); \
                    else if(PyFloat_Check(item)) \
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(obj, i))); \
                    else \
                        success = false; \
                } \
            } \
        } \
        PyErr_Clear(); \
    }

        LabelAttributesObject *LabelObj = (LabelAttributesObject *)self;
        FontAttributes font1 = LabelObj->data->GetTextFont1();
        FontAttributes font2 = LabelObj->data->GetTextFont2();
        if(strcmp(name, "textHeight1") == 0)
        {
            double val;
            if(!PyArg_ParseTuple(tuple, "d", &val))
            {
                Py_DECREF(tuple);
                return -1;
            }
            // Increase the value, new labels are smaller, we want
            // a better approximation of the original size
            font1.SetScale((val+0.02)*100);
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "textHeight2") == 0)
        {
            double val;
            if(!PyArg_ParseTuple(tuple, "d", &val))
            {
                Py_DECREF(tuple);
                return -1;
            }
            // Increase the value, new labels are smaller, we want
            // a better approximation of the original size
            font2.SetScale((val+0.02)*100);
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "specifyTextColor1") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            font1.SetUseForegroundColor(ival == 0 ? 1: 0);
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "specifyTextColor2") == 0)
        {
            int ival;
            if(!PyArg_ParseTuple(tuple, "i", &ival))
            {
                Py_DECREF(tuple);
                return -1;
            }
            font2.SetUseForegroundColor(ival == 0 ? 1: 0);
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "textColor1") == 0)
        {
            int c[4];
            bool success = true;
            GETCOLOR;
            if (success)
            {
                font1.GetColor().SetRgba(c[0], c[1], c[2], c[3]);
                Py_INCREF(Py_None);
                obj = Py_None;
            }
        }
        else if(strcmp(name, "textColor2") == 0)
        {
            int c[4];
            bool success = true;
            GETCOLOR;
            if (success)
            {
                font2.GetColor().SetRgba(c[0], c[1], c[2], c[3]);
                Py_INCREF(Py_None);
                obj = Py_None;
            }
        }
        if (obj != NULL)
        {
            LabelObj->data->SetTextFont1(font1);
            LabelObj->data->SetTextFont2(font2);
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LabelAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)v;
    fprintf(fp, "%s", PyLabelAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LabelAttributes_str(PyObject *v)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)v;
    return PyString_FromString(PyLabelAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LabelAttributes_Purpose = "This class contains the fields that we need to set the attributes for the Label plot.";
#else
static char *LabelAttributes_Purpose = "This class contains the fields that we need to set the attributes for the Label plot.";
#endif

//
// The type description structure
//
static PyTypeObject LabelAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LabelAttributes",                    // tp_name
    sizeof(LabelAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LabelAttributes_dealloc,  // tp_dealloc
    (printfunc)LabelAttributes_print,     // tp_print
    (getattrfunc)PyLabelAttributes_getattr, // tp_getattr
    (setattrfunc)PyLabelAttributes_setattr, // tp_setattr
    (cmpfunc)LabelAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LabelAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LabelAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LabelAttributes *defaultAtts = 0;
static LabelAttributes *currentAtts = 0;

static PyObject *
NewLabelAttributes(int useCurrent)
{
    LabelAttributesObject *newObject;
    newObject = PyObject_NEW(LabelAttributesObject, &LabelAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LabelAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LabelAttributes(*defaultAtts);
    else
        newObject->data = new LabelAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLabelAttributes(const LabelAttributes *attr)
{
    LabelAttributesObject *newObject;
    newObject = PyObject_NEW(LabelAttributesObject, &LabelAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LabelAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LabelAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLabelAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LabelAttributesMethods[] = {
    {"LabelAttributes", LabelAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LabelAttributesObserver = 0;

std::string
PyLabelAttributes_GetLogString()
{
    std::string s("LabelAtts = LabelAttributes()\n");
    if(currentAtts != 0)
        s += PyLabelAttributes_ToString(currentAtts, "LabelAtts.");
    return s;
}

static void
PyLabelAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LabelAtts = LabelAttributes()\n");
        s += PyLabelAttributes_ToString(currentAtts, "LabelAtts.");
        cb(s);
    }
}

void
PyLabelAttributes_StartUp(LabelAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLabelAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LabelAttributesObserver == 0)
    {
        LabelAttributesObserver = new ObserverToCallback(subj,
            PyLabelAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLabelAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LabelAttributesObserver;
    LabelAttributesObserver = 0;
}

PyMethodDef *
PyLabelAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LabelAttributesMethods;
}

bool
PyLabelAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LabelAttributesType);
}

LabelAttributes *
PyLabelAttributes_FromPyObject(PyObject *obj)
{
    LabelAttributesObject *obj2 = (LabelAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLabelAttributes_New()
{
    return NewLabelAttributes(0);
}

PyObject *
PyLabelAttributes_Wrap(const LabelAttributes *attr)
{
    return WrapLabelAttributes(attr);
}

void
PyLabelAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LabelAttributesObject *obj2 = (LabelAttributesObject *)obj;
    obj2->parent = parent;
}

// ****************************************************************************
// Modifications:
//   Brad Whitlock, Thu Aug 4 14:35:00 PST 2005
//   Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************

void
PyLabelAttributes_SetDefaults(const LabelAttributes *atts)
{
    defaultAtts = const_cast<LabelAttributes*>(atts);
}

