// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: LabelViewerEnginePluginInfo.C
// ****************************************************************************

#include <LabelPluginInfo.h>
#include <avtLabelPlot.h>
#include <LabelAttributes.h>

//
// Storage for static data elements.
//
LabelAttributes *LabelViewerEnginePluginInfo::clientAtts = NULL;
LabelAttributes *LabelViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LabelViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
LabelViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (LabelViewerEnginePluginInfo::clientAtts == NULL)
    {
        LabelViewerEnginePluginInfo::clientAtts  = new LabelAttributes;
        LabelViewerEnginePluginInfo::defaultAtts = new LabelAttributes;
    }
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LabelViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
LabelViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LabelViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LabelAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
LabelViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LabelAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
LabelViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtLabelPlot;
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 1 13:55:51 PST 2005
//
//  Modifications:
//    Brad Whitlock, Tue Aug 2 14:21:01 PST 2005
//    Added code to set the variableType in the plot attributes using the
//    metadata.
//
//    Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//    Changed API.
//
// ****************************************************************************

void
LabelViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    *(LabelAttributes*)atts = *defaultAtts;
    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::ReInitializePlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Aug 2 14:23:05 PST 2005
//
//  Modifications:
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
//    Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//    Changed API.
//
// ****************************************************************************

void
LabelViewerEnginePluginInfo::ReInitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    PrivateSetPlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: SubsetViewerPluginInfo::ResetPlotAtts
//
//  Purpose:
//    ReInitialize the plot attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Aug 2 14:23:05 PST 2005
//
//  Modifications:
//    Brad Whitlock, Fri Mar 26 15:22:11 PST 2004
//    I made it use passed in metadata.
//
//    Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//    Changed API.
// ****************************************************************************

void
LabelViewerEnginePluginInfo::ResetPlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)

{
    ReInitializePlotAtts(atts, plot);
}

// ****************************************************************************
//  Method: LabelViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
LabelViewerEnginePluginInfo::GetMenuName() const
{
    return "Label";
}

// ****************************************************************************
// Method: LabelViewerEnginePluginInfo::PrivateSetPlotAtts
//
// Purpose:
//   Initializes the plot's varType attribute using the metadata.
//
// Arguments:
//   atts    : The attributes to initialize.
//   md      : The metadata object.
//   varName : The name of the plot's variable.
//
// Programmer: Brad Whitlock
// Creation:   Tue Aug 2 14:28:36 PST 2005
//
// Modifications:
//   Brad Whitlock, Tue Nov 15 09:49:41 PDT 2005
//   Added code to get the expression type if the DetermineVarType returns
//   a scalar. This allows us to get the right type for things made up of
//   scalars such as vectors.
//
//   Brad Whitlock, Wed Feb 21 14:27:15 PST 2007
//   Changed API.
//
// ****************************************************************************
#include <avtDatabaseMetaData.h>
#include <Expression.h>
#include <DebugStream.h>
#include <avtPlotMetaData.h>
void
LabelViewerEnginePluginInfo::PrivateSetPlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &plot)
{
    LabelAttributes *labelAtts = (LabelAttributes *)atts;

    //
    // Get the meta-data and initialize the variable type in the atts.
    //
    const avtDatabaseMetaData *md = plot.GetMetaData();
    if (md == NULL)
    {
        labelAtts->SetVarType(LabelAttributes::LABEL_VT_UNKNOWN_TYPE);
        return;
    }

    avtSubsetType st = md->DetermineSubsetType(plot.GetVariableName());
    if(st != AVT_UNKNOWN_SUBSET && st != AVT_MATERIAL_SUBSET)
    {
        labelAtts->SetVarType(LabelAttributes::LABEL_VT_SUBSET);
        debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_SUBSET);" << endl;
    }
    else
    {
        avtVarType t = md->DetermineVarType(plot.GetVariableName());

        if(t == AVT_SCALAR_VAR)
        {
            // The final variable type is scalar but we should check if the
            // variable is an expression. If so then we should take the
            // expression's output type if it differs from scalar. This
            // allows us to get the right type for vector expressions, etc.
            for(int i = 0; i < md->GetNumberOfExpressions(); ++i)
            {
                const Expression *e = md->GetExpression(i);
                if(e->GetName() == plot.GetVariableName())
                {
                    if(e->GetType() == Expression::VectorMeshVar)
                        t = AVT_VECTOR_VAR;
                    else if(e->GetType() == Expression::TensorMeshVar)
                        t = AVT_TENSOR_VAR;
                    else if(e->GetType() == Expression::SymmetricTensorMeshVar)
                        t = AVT_SYMMETRIC_TENSOR_VAR;
                    else if(e->GetType() == Expression::ArrayMeshVar)
                        t = AVT_ARRAY_VAR;

                    break;
                }
            }
        }

        if(t == AVT_MESH)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_MESH);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_MESH);" << endl;
        }
        else if(t == AVT_SCALAR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_SCALAR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_SCALAR_VAR);" << endl;
        }
        else if(t == AVT_VECTOR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_VECTOR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_VECTOR_VAR);" << endl;
        }
        else if(t == AVT_TENSOR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_TENSOR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_TENSOR_VAR);" << endl;
        }
        else if(t == AVT_SYMMETRIC_TENSOR_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_SYMMETRIC_TENSOR_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_SYMMETRIC_TENSOR_VAR);" << endl;
        }
        else if(t == AVT_ARRAY_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_ARRAY_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_ARRAY_VAR);" << endl;
        }
        else if(t == AVT_LABEL_VAR)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_LABEL_VAR);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_LABEL_VAR);" << endl;
        }
        else if(t == AVT_MATERIAL)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_MATERIAL);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_MATERIAL);" << endl;
        }
        else if(t == AVT_UNKNOWN_TYPE)
        {
            labelAtts->SetVarType(LabelAttributes::LABEL_VT_UNKNOWN_TYPE);
            debug4 << "labelAtts->SetVarType(LabelAttributes::LABEL_VT_UNKNOWN_TYPE);" << endl;
        }
    }
}

