// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  LabelScriptingPluginInfo.C
// ************************************************************************* //
#include <PyLabelAttributes.h>
#include <LabelPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Label,Scripting)

// ****************************************************************************
// Method: LabelScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LabelScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyLabelAttributes_StartUp((LabelAttributes *)subj, data);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
LabelScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLabelAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Label plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
LabelScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLabelAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
LabelScriptingPluginInfo::GetLogString()
{
    std::string s(PyLabelAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
LabelScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLabelAttributes_SetDefaults((const LabelAttributes *)atts);
}
