// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtHistogramPlot.h                             //
// ************************************************************************* //

#ifndef AVT_Histogram_PLOT_H
#define AVT_Histogram_PLOT_H


#include <avtLegend.h>
#include <avtPlot.h>

#include <HistogramAttributes.h>

class     avtHistogramFilter;
class     avtHistogramMapper;


// ****************************************************************************
//  Class:  avtHistogramPlot
//
//  Purpose:
//      A concrete type of avtPlot, this is the Histogram plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
//  Modifications:
//    Kathleen Biagas, Wed May 11 11:48:15 MST 2016
//    Use avtSimpleMapper instead of custom renderer.
//
// ****************************************************************************

class avtHistogramPlot : public avtLineDataPlot
{
  public:
                                avtHistogramPlot();
    virtual                    ~avtHistogramPlot();

    virtual const char         *GetName(void) { return "HistogramPlot"; };

    static avtPlot             *Create();
    virtual void                ReleaseData(void);

    virtual void                SetAtts(const AttributeGroup*);
    virtual bool                SetForegroundColor(const double *);

  protected:
    HistogramAttributes         atts;

    avtHistogramMapper         *mapper;
    avtHistogramFilter         *HistogramFilter;
    avtFilter                  *amountFilter;
    double                      fgColor[3];

    virtual avtMapperBase      *GetMapper(void);
    virtual avtDataObject_p     ApplyOperators(avtDataObject_p);
    virtual avtDataObject_p     ApplyRenderingTransformation(avtDataObject_p);
    virtual void                CustomizeBehavior(void);

    virtual avtLegend_p         GetLegend(void) { return NULL; };
};


#endif
