// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: HistogramPluginInfo.C
// ****************************************************************************

#include <HistogramPluginInfo.h>
#include <HistogramAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Histogram,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Histogram,General)

// ****************************************************************************
//  Method: HistogramGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
HistogramGeneralPluginInfo::GetName() const
{
    return "Histogram";
}

// ****************************************************************************
//  Method: HistogramGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
HistogramGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: HistogramGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
HistogramGeneralPluginInfo::GetID() const
{
    return "Histogram_1.0";
}
// ****************************************************************************
//  Method: HistogramGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
HistogramGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
