// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: HistogramCommonPluginInfo.C
// ****************************************************************************

#include <HistogramPluginInfo.h>
#include <HistogramAttributes.h>

// ****************************************************************************
//  Method: HistogramCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
HistogramCommonPluginInfo::AllocAttributes()
{
    return new HistogramAttributes;
}

// ****************************************************************************
//  Method: HistogramCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Histogram attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
HistogramCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((HistogramAttributes *) to) = *((HistogramAttributes *) from);
}

// ****************************************************************************
// Method: HistogramCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
HistogramCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_ARRAY;
}

