// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef HISTOGRAMATTRIBUTES_H
#define HISTOGRAMATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

#include <ColorAttribute.h>
#include <PickAttributes.h>

// ****************************************************************************
// Class: HistogramAttributes
//
// Purpose:
//    Attributes for Histogram Plot
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class HistogramAttributes : public AttributeSubject
{
public:
    enum OutputType
    {
        Curve,
        Block
    };
    enum BasedOn
    {
        ManyVarsForSingleZone,
        ManyZonesForSingleVar
    };
    enum BinContribution
    {
        Frequency,
        Weighted,
        Variable
    };
    enum LimitsMode
    {
        OriginalData,
        CurrentPlot
    };
    enum DataScale
    {
        Linear,
        Log,
        SquareRoot
    };

    // These constructors are for objects of this class
    HistogramAttributes();
    HistogramAttributes(const HistogramAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    HistogramAttributes(private_tmfs_t tmfs);
    HistogramAttributes(const HistogramAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~HistogramAttributes();

    virtual HistogramAttributes& operator = (const HistogramAttributes &obj);
    virtual bool operator == (const HistogramAttributes &obj) const;
    virtual bool operator != (const HistogramAttributes &obj) const;
private:
    void Init();
    void Copy(const HistogramAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectWeightVariable();
    void SelectColor();

    // Property setting methods
    void SetBasedOn(BasedOn basedOn_);
    void SetHistogramType(BinContribution histogramType_);
    void SetWeightVariable(const std::string &weightVariable_);
    void SetLimitsMode(LimitsMode limitsMode_);
    void SetMinFlag(bool minFlag_);
    void SetMaxFlag(bool maxFlag_);
    void SetMin(double min_);
    void SetMax(double max_);
    void SetNumBins(int numBins_);
    void SetDomain(int domain_);
    void SetZone(int zone_);
    void SetUseBinWidths(bool useBinWidths_);
    void SetOutputType(OutputType outputType_);
    void SetLineWidth(int lineWidth_);
    void SetColor(const ColorAttribute &color_);
    void SetDataScale(DataScale dataScale_);
    void SetBinScale(DataScale binScale_);
    void SetNormalizeHistogram(bool normalizeHistogram_);
    void SetComputeAsCDF(bool computeAsCDF_);

    // Property getting methods
    BasedOn              GetBasedOn() const;
    BinContribution      GetHistogramType() const;
    const std::string    &GetWeightVariable() const;
          std::string    &GetWeightVariable();
    LimitsMode           GetLimitsMode() const;
    bool                 GetMinFlag() const;
    bool                 GetMaxFlag() const;
    double               GetMin() const;
    double               GetMax() const;
    int                  GetNumBins() const;
    int                  GetDomain() const;
    int                  GetZone() const;
    bool                 GetUseBinWidths() const;
    OutputType           GetOutputType() const;
    int                  GetLineWidth() const;
    const ColorAttribute &GetColor() const;
          ColorAttribute &GetColor();
    DataScale            GetDataScale() const;
    DataScale            GetBinScale() const;
    bool                 GetNormalizeHistogram() const;
    bool                 GetComputeAsCDF() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string OutputType_ToString(OutputType);
    static bool OutputType_FromString(const std::string &, OutputType &);
protected:
    static std::string OutputType_ToString(int);
public:
    static std::string BasedOn_ToString(BasedOn);
    static bool BasedOn_FromString(const std::string &, BasedOn &);
protected:
    static std::string BasedOn_ToString(int);
public:
    static std::string BinContribution_ToString(BinContribution);
    static bool BinContribution_FromString(const std::string &, BinContribution &);
protected:
    static std::string BinContribution_ToString(int);
public:
    static std::string LimitsMode_ToString(LimitsMode);
    static bool LimitsMode_FromString(const std::string &, LimitsMode &);
protected:
    static std::string LimitsMode_ToString(int);
public:
    static std::string DataScale_ToString(DataScale);
    static bool DataScale_FromString(const std::string &, DataScale &);
protected:
    static std::string DataScale_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool ChangesRequireRecalculation(const HistogramAttributes &) const;
    virtual bool VarChangeRequiresReset(void);
    virtual void ProcessOldVersions(DataNode *parentNode, const char *configVersion);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_basedOn = 0,
        ID_histogramType,
        ID_weightVariable,
        ID_limitsMode,
        ID_minFlag,
        ID_maxFlag,
        ID_min,
        ID_max,
        ID_numBins,
        ID_domain,
        ID_zone,
        ID_useBinWidths,
        ID_outputType,
        ID_lineWidth,
        ID_color,
        ID_dataScale,
        ID_binScale,
        ID_normalizeHistogram,
        ID_computeAsCDF,
        ID__LAST
    };

private:
    int            basedOn;
    int            histogramType;
    std::string    weightVariable;
    int            limitsMode;
    bool           minFlag;
    bool           maxFlag;
    double         min;
    double         max;
    int            numBins;
    int            domain;
    int            zone;
    bool           useBinWidths;
    int            outputType;
    int            lineWidth;
    ColorAttribute color;
    int            dataScale;
    int            binScale;
    bool           normalizeHistogram;
    bool           computeAsCDF;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define HISTOGRAMATTRIBUTES_TMFS "iisibbddiiibiiaiibb"

#endif
