// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: FilledBoundaryGUIPluginInfo.C
// ****************************************************************************

#include <FilledBoundaryPluginInfo.h>
#include <FilledBoundaryAttributes.h>
#include <QApplication>
#include <QvisFilledBoundaryPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(FilledBoundary,GUI)

// ****************************************************************************
//  Method: FilledBoundaryGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
FilledBoundaryGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Filled Boundary"));
}


// ****************************************************************************
//  Method: FilledBoundaryGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
FilledBoundaryGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisFilledBoundaryPlotWindow(type, (FilledBoundaryAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: FilledBoundaryGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <FilledBoundary.xpm>
const char **
FilledBoundaryGUIPluginInfo::XPMIconData() const
{
    return FilledBoundary_xpm;
}

