// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                                avtCurvePlot.h                             //
// ************************************************************************* //

#ifndef AVT_CURVE_PLOT_H
#define AVT_CURVE_PLOT_H


#include <avtLegend.h>
#include <avtPlot.h>

#include <CurveAttributes.h>

class     avtCurveFilter;
class     avtCurveMapper;
class     avtCurveLegend;
class     avtLabeledCurveMapper;
class     avtWarpFilter;
class     avtPolarToCartesianFilter;
class     vtkProperty;


// ****************************************************************************
//  Class:  avtCurvePlot
//
//  Purpose:
//      A concrete type of avtPlot, this is the Curve plot.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//    Kathleen Bonnell, Fri Jul 12 16:53:11 PDT 2002 
//    Added labeled curve mapper.
//
//    Kathleen Bonnell, Tue Oct 22 08:33:26 PDT 2002
//    Added ApplyRenderingTransformation. 
//    
//    Kathleen Bonnell, Thu Oct 27 15:12:13 PDT 2005 
//    Added Legend. 
//    
//    Kathleen Bonnell, Wed Jul 12 08:30:04 PDT 2006 
//    Added warp filter. 
//    
//    Kathleen Bonnell, Tue Apr  3 17:17:33 PDT 2007 
//    Added CanDoCurveViewScaling. 
//    
//    Kathleen Bonnell, Tue Mar  3 13:37:13 PST 2009
//    Removed CanDo2DViewScaling (moved into Viewer PluginInfo)
//
//    Kathleen Biagas, Wed Sep 11 17:14:35 PDT 2013
//    Added PolarFilter.
//
// ****************************************************************************


class avtCurvePlot : public avtLineDataPlot
{
  public:
                                avtCurvePlot();
    virtual                    ~avtCurvePlot();

    virtual const char         *GetName(void) { return "CurvePlot"; };
    virtual void                ReleaseData(void);

    static avtPlot             *Create();

    virtual void                SetAtts(const AttributeGroup*);
    void                        SetLineWidth(int);
    virtual bool                SetBackgroundColor(const double *);

  protected:
    CurveAttributes                atts;

    avtCurveLegend                *curveLegend;
    avtLegend_p                    curveLegendRefPtr;

    avtCurveMapper                *mapper;
    avtLabeledCurveMapper         *decoMapper;

    avtCurveFilter                *CurveFilter;
    avtWarpFilter                 *WarpFilter;
    avtPolarToCartesianFilter     *PolarFilter;

    double                         bgColor[3];

    virtual avtMapperBase      *GetMapper(void);
    virtual avtDataObject_p     ApplyOperators(avtDataObject_p);
    virtual avtDataObject_p     ApplyRenderingTransformation(avtDataObject_p);
    virtual void                CustomizeBehavior(void);

    virtual avtLegend_p         GetLegend(void) { return curveLegendRefPtr; };
    virtual avtDecorationsMapper *GetDecorationsMapper(void); 
};

#endif


